/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.rolesanywhere.model.AccessDeniedException;
import software.amazon.awssdk.services.rolesanywhere.model.CreateProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.CreateProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.CreateTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.CreateTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DisableCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DisableCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DisableProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DisableProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DisableTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DisableTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.EnableCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.EnableCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.EnableProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.EnableProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.EnableTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.EnableTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.GetCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.GetCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.GetProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.GetProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.GetSubjectRequest;
import software.amazon.awssdk.services.rolesanywhere.model.GetSubjectResponse;
import software.amazon.awssdk.services.rolesanywhere.model.GetTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.GetTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ImportCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ImportCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListCrlsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListCrlsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListProfilesRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListProfilesResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereException;
import software.amazon.awssdk.services.rolesanywhere.model.TagResourceRequest;
import software.amazon.awssdk.services.rolesanywhere.model.TagResourceResponse;
import software.amazon.awssdk.services.rolesanywhere.model.TooManyTagsException;
import software.amazon.awssdk.services.rolesanywhere.model.UntagResourceRequest;
import software.amazon.awssdk.services.rolesanywhere.model.UntagResourceResponse;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ValidationException;
import software.amazon.awssdk.services.rolesanywhere.paginators.ListCrlsIterable;
import software.amazon.awssdk.services.rolesanywhere.paginators.ListProfilesIterable;
import software.amazon.awssdk.services.rolesanywhere.paginators.ListSubjectsIterable;
import software.amazon.awssdk.services.rolesanywhere.paginators.ListTrustAnchorsIterable;

/**
 * Service client for accessing IAM Roles Anywhere. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Identity and Access Management Roles Anywhere provides a secure way for your workloads such as servers,
 * containers, and applications running outside of AWS to obtain Temporary AWS credentials. Your workloads can use the
 * same IAM policies and roles that you have configured with native AWS applications to access AWS resources. Using IAM
 * Roles Anywhere will eliminate the need to manage long term credentials for workloads running outside of AWS.
 * </p>
 * <p>
 * To use IAM Roles Anywhere customer workloads will need to use X.509 certificates issued by their Certificate
 * Authority (CA) . The Certificate Authority (CA) needs to be registered with IAM Roles Anywhere as a trust anchor to
 * establish trust between customer PKI and IAM Roles Anywhere. Customers who do not manage their own PKI system can use
 * AWS Certificate Manager Private Certificate Authority (ACM PCA) to create a Certificate Authority and use that to
 * establish trust with IAM Roles Anywhere
 * </p>
 * <p>
 * This guide describes the IAM rolesanywhere operations that you can call programmatically. For general information
 * about IAM Roles Anywhere see <a href="https://docs.aws.amazon.com/">https://docs.aws.amazon.com/</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RolesAnywhereClient extends AwsClient {
    String SERVICE_NAME = "rolesanywhere";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "rolesanywhere";

    /**
     * <p>
     * Creates a profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to
     * assume. In addition, by applying a profile you can intersect permissions with IAM managed policies.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:CreateProfile</code>.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to
     * assume. In addition, by applying a profile you can intersect permissions with IAM managed policies.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:CreateProfile</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateProfileRequest.Builder} to create a request.
     * @return Result of the CreateProfile operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProfileResponse createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Creates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate authority (CA) by
     * configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private
     * Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can
     * authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in
     * exchange for temporary AWS credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:CreateTrustAnchor</code>.
     * </p>
     *
     * @param createTrustAnchorRequest
     * @return Result of the CreateTrustAnchor operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.CreateTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/CreateTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrustAnchorResponse createTrustAnchor(CreateTrustAnchorRequest createTrustAnchorRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate authority (CA) by
     * configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private
     * Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can
     * authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in
     * exchange for temporary AWS credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:CreateTrustAnchor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrustAnchorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTrustAnchorRequest#builder()}
     * </p>
     *
     * @param createTrustAnchorRequest
     *        A {@link Consumer} that will call methods on {@link CreateTrustAnchorRequest.Builder} to create a request.
     * @return Result of the CreateTrustAnchor operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.CreateTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/CreateTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrustAnchorResponse createTrustAnchor(Consumer<CreateTrustAnchorRequest.Builder> createTrustAnchorRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return createTrustAnchor(CreateTrustAnchorRequest.builder().applyMutation(createTrustAnchorRequest).build());
    }

    /**
     * <p>
     * Deletes a certificate revocation list (CRL).
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DeleteCrl</code>.
     * </p>
     *
     * @param deleteCrlRequest
     * @return Result of the DeleteCrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DeleteCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCrlResponse deleteCrl(DeleteCrlRequest deleteCrlRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a certificate revocation list (CRL).
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DeleteCrl</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCrlRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCrlRequest#builder()}
     * </p>
     *
     * @param deleteCrlRequest
     *        A {@link Consumer} that will call methods on {@link ScalarCrlRequest.Builder} to create a request.
     * @return Result of the DeleteCrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DeleteCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCrlResponse deleteCrl(Consumer<DeleteCrlRequest.Builder> deleteCrlRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return deleteCrl(DeleteCrlRequest.builder().applyMutation(deleteCrlRequest).build());
    }

    /**
     * <p>
     * Deletes a profile.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DeleteProfile</code>.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a profile.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DeleteProfile</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on {@link ScalarProfileRequest.Builder} to create a request.
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a trust anchor.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DeleteTrustAnchor</code>.
     * </p>
     *
     * @param deleteTrustAnchorRequest
     * @return Result of the DeleteTrustAnchor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DeleteTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrustAnchorResponse deleteTrustAnchor(DeleteTrustAnchorRequest deleteTrustAnchorRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a trust anchor.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DeleteTrustAnchor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrustAnchorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTrustAnchorRequest#builder()}
     * </p>
     *
     * @param deleteTrustAnchorRequest
     *        A {@link Consumer} that will call methods on {@link ScalarTrustAnchorRequest.Builder} to create a request.
     * @return Result of the DeleteTrustAnchor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DeleteTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrustAnchorResponse deleteTrustAnchor(Consumer<DeleteTrustAnchorRequest.Builder> deleteTrustAnchorRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return deleteTrustAnchor(DeleteTrustAnchorRequest.builder().applyMutation(deleteTrustAnchorRequest).build());
    }

    /**
     * <p>
     * Disables a certificate revocation list (CRL).
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DisableCrl</code>.
     * </p>
     *
     * @param disableCrlRequest
     * @return Result of the DisableCrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DisableCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableCrlResponse disableCrl(DisableCrlRequest disableCrlRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables a certificate revocation list (CRL).
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DisableCrl</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableCrlRequest.Builder} avoiding the need to
     * create one manually via {@link DisableCrlRequest#builder()}
     * </p>
     *
     * @param disableCrlRequest
     *        A {@link Consumer} that will call methods on {@link ScalarCrlRequest.Builder} to create a request.
     * @return Result of the DisableCrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DisableCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableCrlResponse disableCrl(Consumer<DisableCrlRequest.Builder> disableCrlRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return disableCrl(DisableCrlRequest.builder().applyMutation(disableCrlRequest).build());
    }

    /**
     * <p>
     * Disables a profile. When disabled, <a
     * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>
     * requests with this profile fail.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DisableProfile</code>.
     * </p>
     *
     * @param disableProfileRequest
     * @return Result of the DisableProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DisableProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableProfileResponse disableProfile(DisableProfileRequest disableProfileRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables a profile. When disabled, <a
     * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>
     * requests with this profile fail.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DisableProfile</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DisableProfileRequest#builder()}
     * </p>
     *
     * @param disableProfileRequest
     *        A {@link Consumer} that will call methods on {@link ScalarProfileRequest.Builder} to create a request.
     * @return Result of the DisableProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DisableProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableProfileResponse disableProfile(Consumer<DisableProfileRequest.Builder> disableProfileRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return disableProfile(DisableProfileRequest.builder().applyMutation(disableProfileRequest).build());
    }

    /**
     * <p>
     * Disables a trust anchor. When disabled, <a
     * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>
     * requests specifying this trust anchor are unauthorized.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DisableTrustAnchor</code>.
     * </p>
     *
     * @param disableTrustAnchorRequest
     * @return Result of the DisableTrustAnchor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DisableTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableTrustAnchorResponse disableTrustAnchor(DisableTrustAnchorRequest disableTrustAnchorRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables a trust anchor. When disabled, <a
     * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>
     * requests specifying this trust anchor are unauthorized.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:DisableTrustAnchor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableTrustAnchorRequest.Builder} avoiding the
     * need to create one manually via {@link DisableTrustAnchorRequest#builder()}
     * </p>
     *
     * @param disableTrustAnchorRequest
     *        A {@link Consumer} that will call methods on {@link ScalarTrustAnchorRequest.Builder} to create a request.
     * @return Result of the DisableTrustAnchor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.DisableTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableTrustAnchorResponse disableTrustAnchor(Consumer<DisableTrustAnchorRequest.Builder> disableTrustAnchorRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return disableTrustAnchor(DisableTrustAnchorRequest.builder().applyMutation(disableTrustAnchorRequest).build());
    }

    /**
     * <p>
     * Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL are unauthorized to
     * receive session credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:EnableCrl</code>.
     * </p>
     *
     * @param enableCrlRequest
     * @return Result of the EnableCrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.EnableCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableCrlResponse enableCrl(EnableCrlRequest enableCrlRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL are unauthorized to
     * receive session credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:EnableCrl</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableCrlRequest.Builder} avoiding the need to
     * create one manually via {@link EnableCrlRequest#builder()}
     * </p>
     *
     * @param enableCrlRequest
     *        A {@link Consumer} that will call methods on {@link ScalarCrlRequest.Builder} to create a request.
     * @return Result of the EnableCrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.EnableCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableCrlResponse enableCrl(Consumer<EnableCrlRequest.Builder> enableCrlRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return enableCrl(EnableCrlRequest.builder().applyMutation(enableCrlRequest).build());
    }

    /**
     * <p>
     * Enables the roles in a profile to receive session credentials in <a
     * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:EnableProfile</code>.
     * </p>
     *
     * @param enableProfileRequest
     * @return Result of the EnableProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.EnableProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableProfileResponse enableProfile(EnableProfileRequest enableProfileRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the roles in a profile to receive session credentials in <a
     * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:EnableProfile</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableProfileRequest.Builder} avoiding the need to
     * create one manually via {@link EnableProfileRequest#builder()}
     * </p>
     *
     * @param enableProfileRequest
     *        A {@link Consumer} that will call methods on {@link ScalarProfileRequest.Builder} to create a request.
     * @return Result of the EnableProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.EnableProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableProfileResponse enableProfile(Consumer<EnableProfileRequest.Builder> enableProfileRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return enableProfile(EnableProfileRequest.builder().applyMutation(enableProfileRequest).build());
    }

    /**
     * <p>
     * Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized for trust validation.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:EnableTrustAnchor</code>.
     * </p>
     *
     * @param enableTrustAnchorRequest
     * @return Result of the EnableTrustAnchor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.EnableTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableTrustAnchorResponse enableTrustAnchor(EnableTrustAnchorRequest enableTrustAnchorRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized for trust validation.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:EnableTrustAnchor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableTrustAnchorRequest.Builder} avoiding the need
     * to create one manually via {@link EnableTrustAnchorRequest#builder()}
     * </p>
     *
     * @param enableTrustAnchorRequest
     *        A {@link Consumer} that will call methods on {@link ScalarTrustAnchorRequest.Builder} to create a request.
     * @return Result of the EnableTrustAnchor operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.EnableTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableTrustAnchorResponse enableTrustAnchor(Consumer<EnableTrustAnchorRequest.Builder> enableTrustAnchorRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return enableTrustAnchor(EnableTrustAnchorRequest.builder().applyMutation(enableTrustAnchorRequest).build());
    }

    /**
     * <p>
     * Gets a certificate revocation list (CRL).
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:GetCrl</code>.
     * </p>
     *
     * @param getCrlRequest
     * @return Result of the GetCrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.GetCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrlResponse getCrl(GetCrlRequest getCrlRequest) throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a certificate revocation list (CRL).
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:GetCrl</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrlRequest.Builder} avoiding the need to create
     * one manually via {@link GetCrlRequest#builder()}
     * </p>
     *
     * @param getCrlRequest
     *        A {@link Consumer} that will call methods on {@link ScalarCrlRequest.Builder} to create a request.
     * @return Result of the GetCrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.GetCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrlResponse getCrl(Consumer<GetCrlRequest.Builder> getCrlRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, RolesAnywhereException {
        return getCrl(GetCrlRequest.builder().applyMutation(getCrlRequest).build());
    }

    /**
     * <p>
     * Gets a profile.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:GetProfile</code>.
     * </p>
     *
     * @param getProfileRequest
     * @return Result of the GetProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a profile.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:GetProfile</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetProfileRequest#builder()}
     * </p>
     *
     * @param getProfileRequest
     *        A {@link Consumer} that will call methods on {@link ScalarProfileRequest.Builder} to create a request.
     * @return Result of the GetProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProfileResponse getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return getProfile(GetProfileRequest.builder().applyMutation(getProfileRequest).build());
    }

    /**
     * <p>
     * Gets a Subject. A Subject associates a certificate identity with authentication attempts by CreateSession. The
     * Subject resources stores audit information such as status of the last authentication attempt, the certificate
     * data used in the attempt, and the last time the associated identity attempted authentication.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:GetSubject</code>.
     * </p>
     *
     * @param getSubjectRequest
     * @return Result of the GetSubject operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.GetSubject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetSubject" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSubjectResponse getSubject(GetSubjectRequest getSubjectRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Subject. A Subject associates a certificate identity with authentication attempts by CreateSession. The
     * Subject resources stores audit information such as status of the last authentication attempt, the certificate
     * data used in the attempt, and the last time the associated identity attempted authentication.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:GetSubject</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetSubjectRequest#builder()}
     * </p>
     *
     * @param getSubjectRequest
     *        A {@link Consumer} that will call methods on {@link ScalarSubjectRequest.Builder} to create a request.
     * @return Result of the GetSubject operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.GetSubject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetSubject" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSubjectResponse getSubject(Consumer<GetSubjectRequest.Builder> getSubjectRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return getSubject(GetSubjectRequest.builder().applyMutation(getSubjectRequest).build());
    }

    /**
     * <p>
     * Gets a trust anchor.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:GetTrustAnchor</code>.
     * </p>
     *
     * @param getTrustAnchorRequest
     * @return Result of the GetTrustAnchor operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.GetTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetTrustAnchor" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTrustAnchorResponse getTrustAnchor(GetTrustAnchorRequest getTrustAnchorRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a trust anchor.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:GetTrustAnchor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrustAnchorRequest.Builder} avoiding the need to
     * create one manually via {@link GetTrustAnchorRequest#builder()}
     * </p>
     *
     * @param getTrustAnchorRequest
     *        A {@link Consumer} that will call methods on {@link ScalarTrustAnchorRequest.Builder} to create a request.
     * @return Result of the GetTrustAnchor operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.GetTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetTrustAnchor" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTrustAnchorResponse getTrustAnchor(Consumer<GetTrustAnchorRequest.Builder> getTrustAnchorRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, RolesAnywhereException {
        return getTrustAnchor(GetTrustAnchorRequest.builder().applyMutation(getTrustAnchorRequest).build());
    }

    /**
     * <p>
     * Imports the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the
     * issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ImportCrl</code>.
     * </p>
     *
     * @param importCrlRequest
     * @return Result of the ImportCrl operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ImportCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ImportCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportCrlResponse importCrl(ImportCrlRequest importCrlRequest) throws ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the
     * issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ImportCrl</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportCrlRequest.Builder} avoiding the need to
     * create one manually via {@link ImportCrlRequest#builder()}
     * </p>
     *
     * @param importCrlRequest
     *        A {@link Consumer} that will call methods on {@link ImportCrlRequest.Builder} to create a request.
     * @return Result of the ImportCrl operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ImportCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ImportCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportCrlResponse importCrl(Consumer<ImportCrlRequest.Builder> importCrlRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return importCrl(ImportCrlRequest.builder().applyMutation(importCrlRequest).build());
    }

    /**
     * <p>
     * Lists all Crls in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListCrls</code>.
     * </p>
     *
     * @param listCrlsRequest
     * @return Result of the ListCrls operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListCrls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListCrls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCrlsResponse listCrls(ListCrlsRequest listCrlsRequest) throws ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Crls in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListCrls</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCrlsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCrlsRequest#builder()}
     * </p>
     *
     * @param listCrlsRequest
     *        A {@link Consumer} that will call methods on {@link ListRequest.Builder} to create a request.
     * @return Result of the ListCrls operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListCrls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListCrls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCrlsResponse listCrls(Consumer<ListCrlsRequest.Builder> listCrlsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return listCrls(ListCrlsRequest.builder().applyMutation(listCrlsRequest).build());
    }

    /**
     * <p>
     * Lists all Crls in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListCrls</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCrls(software.amazon.awssdk.services.rolesanywhere.model.ListCrlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListCrlsIterable responses = client.listCrlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rolesanywhere.paginators.ListCrlsIterable responses = client.listCrlsPaginator(request);
     *     for (software.amazon.awssdk.services.rolesanywhere.model.ListCrlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListCrlsIterable responses = client.listCrlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCrls(software.amazon.awssdk.services.rolesanywhere.model.ListCrlsRequest)} operation.</b>
     * </p>
     *
     * @param listCrlsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListCrls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListCrls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCrlsIterable listCrlsPaginator(ListCrlsRequest listCrlsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Crls in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListCrls</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCrls(software.amazon.awssdk.services.rolesanywhere.model.ListCrlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListCrlsIterable responses = client.listCrlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rolesanywhere.paginators.ListCrlsIterable responses = client.listCrlsPaginator(request);
     *     for (software.amazon.awssdk.services.rolesanywhere.model.ListCrlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListCrlsIterable responses = client.listCrlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCrls(software.amazon.awssdk.services.rolesanywhere.model.ListCrlsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCrlsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCrlsRequest#builder()}
     * </p>
     *
     * @param listCrlsRequest
     *        A {@link Consumer} that will call methods on {@link ListRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListCrls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListCrls" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCrlsIterable listCrlsPaginator(Consumer<ListCrlsRequest.Builder> listCrlsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return listCrlsPaginator(ListCrlsRequest.builder().applyMutation(listCrlsRequest).build());
    }

    /**
     * <p>
     * Lists all profiles in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListProfiles</code>.
     * </p>
     *
     * @param listProfilesRequest
     * @return Result of the ListProfiles operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProfilesResponse listProfiles(ListProfilesRequest listProfilesRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all profiles in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListProfiles</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListRequest.Builder} to create a request.
     * @return Result of the ListProfiles operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProfilesResponse listProfiles(Consumer<ListProfilesRequest.Builder> listProfilesRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return listProfiles(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * Lists all profiles in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListProfiles</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfiles(software.amazon.awssdk.services.rolesanywhere.model.ListProfilesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rolesanywhere.paginators.ListProfilesIterable responses = client
     *             .listProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.rolesanywhere.model.ListProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.rolesanywhere.model.ListProfilesRequest)} operation.</b>
     * </p>
     *
     * @param listProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProfilesIterable listProfilesPaginator(ListProfilesRequest listProfilesRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all profiles in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListProfiles</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfiles(software.amazon.awssdk.services.rolesanywhere.model.ListProfilesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rolesanywhere.paginators.ListProfilesIterable responses = client
     *             .listProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.rolesanywhere.model.ListProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.rolesanywhere.model.ListProfilesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProfilesIterable listProfilesPaginator(Consumer<ListProfilesRequest.Builder> listProfilesRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return listProfilesPaginator(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the subjects in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListSubjects</code>.
     * </p>
     *
     * @param listSubjectsRequest
     * @return Result of the ListSubjects operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListSubjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListSubjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubjectsResponse listSubjects(ListSubjectsRequest listSubjectsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the subjects in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListSubjects</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSubjectsRequest#builder()}
     * </p>
     *
     * @param listSubjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListRequest.Builder} to create a request.
     * @return Result of the ListSubjects operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListSubjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListSubjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubjectsResponse listSubjects(Consumer<ListSubjectsRequest.Builder> listSubjectsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return listSubjects(ListSubjectsRequest.builder().applyMutation(listSubjectsRequest).build());
    }

    /**
     * <p>
     * Lists the subjects in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListSubjects</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubjects(software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListSubjectsIterable responses = client.listSubjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rolesanywhere.paginators.ListSubjectsIterable responses = client
     *             .listSubjectsPaginator(request);
     *     for (software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListSubjectsIterable responses = client.listSubjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubjects(software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsRequest)} operation.</b>
     * </p>
     *
     * @param listSubjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListSubjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListSubjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubjectsIterable listSubjectsPaginator(ListSubjectsRequest listSubjectsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the subjects in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListSubjects</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubjects(software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListSubjectsIterable responses = client.listSubjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rolesanywhere.paginators.ListSubjectsIterable responses = client
     *             .listSubjectsPaginator(request);
     *     for (software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListSubjectsIterable responses = client.listSubjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubjects(software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSubjectsRequest#builder()}
     * </p>
     *
     * @param listSubjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListSubjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListSubjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubjectsIterable listSubjectsPaginator(Consumer<ListSubjectsRequest.Builder> listSubjectsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return listSubjectsPaginator(ListSubjectsRequest.builder().applyMutation(listSubjectsRequest).build());
    }

    /**
     * <p>
     * Lists the tags attached to the resource.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListTagsForResource</code>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags attached to the resource.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListTagsForResource</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the trust anchors in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListTrustAnchors</code>.
     * </p>
     *
     * @param listTrustAnchorsRequest
     * @return Result of the ListTrustAnchors operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListTrustAnchors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTrustAnchors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustAnchorsResponse listTrustAnchors(ListTrustAnchorsRequest listTrustAnchorsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the trust anchors in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListTrustAnchors</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustAnchorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrustAnchorsRequest#builder()}
     * </p>
     *
     * @param listTrustAnchorsRequest
     *        A {@link Consumer} that will call methods on {@link ListRequest.Builder} to create a request.
     * @return Result of the ListTrustAnchors operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListTrustAnchors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTrustAnchors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustAnchorsResponse listTrustAnchors(Consumer<ListTrustAnchorsRequest.Builder> listTrustAnchorsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return listTrustAnchors(ListTrustAnchorsRequest.builder().applyMutation(listTrustAnchorsRequest).build());
    }

    /**
     * <p>
     * Lists the trust anchors in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListTrustAnchors</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrustAnchors(software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListTrustAnchorsIterable responses = client.listTrustAnchorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rolesanywhere.paginators.ListTrustAnchorsIterable responses = client
     *             .listTrustAnchorsPaginator(request);
     *     for (software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListTrustAnchorsIterable responses = client.listTrustAnchorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustAnchors(software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustAnchorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListTrustAnchors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTrustAnchors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustAnchorsIterable listTrustAnchorsPaginator(ListTrustAnchorsRequest listTrustAnchorsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the trust anchors in the authenticated account and Amazon Web Services Region.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:ListTrustAnchors</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrustAnchors(software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListTrustAnchorsIterable responses = client.listTrustAnchorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rolesanywhere.paginators.ListTrustAnchorsIterable responses = client
     *             .listTrustAnchorsPaginator(request);
     *     for (software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rolesanywhere.paginators.ListTrustAnchorsIterable responses = client.listTrustAnchorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustAnchors(software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustAnchorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrustAnchorsRequest#builder()}
     * </p>
     *
     * @param listTrustAnchorsRequest
     *        A {@link Consumer} that will call methods on {@link ListRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Validation exception error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.ListTrustAnchors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTrustAnchors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustAnchorsIterable listTrustAnchorsPaginator(Consumer<ListTrustAnchorsRequest.Builder> listTrustAnchorsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return listTrustAnchorsPaginator(ListTrustAnchorsRequest.builder().applyMutation(listTrustAnchorsRequest).build());
    }

    /**
     * <p>
     * Attaches tags to a resource.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:TagResource</code>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws TooManyTagsException
     *         Too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, TooManyTagsException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches tags to a resource.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:TagResource</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws TooManyTagsException
     *         Too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, TooManyTagsException, AwsServiceException, SdkClientException,
            RolesAnywhereException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the resource.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:UntagResource</code>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the resource.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:UntagResource</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, RolesAnywhereException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the
     * issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:UpdateCrl</code>.
     * </p>
     *
     * @param updateCrlRequest
     * @return Result of the UpdateCrl operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.UpdateCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCrlResponse updateCrl(UpdateCrlRequest updateCrlRequest) throws ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the
     * issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:UpdateCrl</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCrlRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCrlRequest#builder()}
     * </p>
     *
     * @param updateCrlRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCrlRequest.Builder} to create a request.
     * @return Result of the UpdateCrl operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.UpdateCrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateCrl" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCrlResponse updateCrl(Consumer<UpdateCrlRequest.Builder> updateCrlRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return updateCrl(UpdateCrlRequest.builder().applyMutation(updateCrlRequest).build());
    }

    /**
     * <p>
     * Updates the profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted
     * to assume. In addition, by applying a profile you can scope-down permissions with IAM managed policies.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:UpdateProfile</code>.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted
     * to assume. In addition, by applying a profile you can scope-down permissions with IAM managed policies.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:UpdateProfile</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProfileRequest.Builder} to create a request.
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, RolesAnywhereException {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * <p>
     * Updates the trust anchor.You establish trust between IAM Roles Anywhere and your certificate authority (CA) by
     * configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private
     * Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can
     * authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in
     * exchange for temporary AWS credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:UpdateTrustAnchor</code>.
     * </p>
     *
     * @param updateTrustAnchorRequest
     * @return Result of the UpdateTrustAnchor operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.UpdateTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTrustAnchorResponse updateTrustAnchor(UpdateTrustAnchorRequest updateTrustAnchorRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, RolesAnywhereException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the trust anchor.You establish trust between IAM Roles Anywhere and your certificate authority (CA) by
     * configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private
     * Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can
     * authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in
     * exchange for temporary AWS credentials.
     * </p>
     * <p>
     * <b>Required permissions: </b> <code>rolesanywhere:UpdateTrustAnchor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrustAnchorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTrustAnchorRequest#builder()}
     * </p>
     *
     * @param updateTrustAnchorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTrustAnchorRequest.Builder} to create a request.
     * @return Result of the UpdateTrustAnchor operation returned by the service.
     * @throws ValidationException
     *         Validation exception error.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RolesAnywhereException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RolesAnywhereClient.UpdateTrustAnchor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateTrustAnchor"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTrustAnchorResponse updateTrustAnchor(Consumer<UpdateTrustAnchorRequest.Builder> updateTrustAnchorRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, RolesAnywhereException {
        return updateTrustAnchor(UpdateTrustAnchorRequest.builder().applyMutation(updateTrustAnchorRequest).build());
    }

    /**
     * Create a {@link RolesAnywhereClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RolesAnywhereClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RolesAnywhereClient}.
     */
    static RolesAnywhereClientBuilder builder() {
        return new DefaultRolesAnywhereClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default RolesAnywhereServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
