/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of the trust anchor after a read or write operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustAnchorDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustAnchorDetail.Builder, TrustAnchorDetail> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(TrustAnchorDetail::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(TrustAnchorDetail::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TrustAnchorDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(TrustAnchorDetail::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TRUST_ANCHOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustAnchorArn").getter(getter(TrustAnchorDetail::trustAnchorArn))
            .setter(setter(Builder::trustAnchorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorArn").build()).build();

    private static final SdkField<String> TRUST_ANCHOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustAnchorId").getter(getter(TrustAnchorDetail::trustAnchorId)).setter(setter(Builder::trustAnchorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorId").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(TrustAnchorDetail::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            ENABLED_FIELD, NAME_FIELD, SOURCE_FIELD, TRUST_ANCHOR_ARN_FIELD, TRUST_ANCHOR_ID_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Boolean enabled;

    private final String name;

    private final Source source;

    private final String trustAnchorArn;

    private final String trustAnchorId;

    private final Instant updatedAt;

    private TrustAnchorDetail(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.enabled = builder.enabled;
        this.name = builder.name;
        this.source = builder.source;
        this.trustAnchorArn = builder.trustAnchorArn;
        this.trustAnchorId = builder.trustAnchorId;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ISO-8601 timestamp when the trust anchor was created.
     * </p>
     * 
     * @return The ISO-8601 timestamp when the trust anchor was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Indicates whether the trust anchor is enabled.
     * </p>
     * 
     * @return Indicates whether the trust anchor is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the trust anchor.
     * </p>
     * 
     * @return The name of the trust anchor.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The trust anchor type and its related certificate data.
     * </p>
     * 
     * @return The trust anchor type and its related certificate data.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * The ARN of the trust anchor.
     * </p>
     * 
     * @return The ARN of the trust anchor.
     */
    public final String trustAnchorArn() {
        return trustAnchorArn;
    }

    /**
     * <p>
     * The unique identifier of the trust anchor.
     * </p>
     * 
     * @return The unique identifier of the trust anchor.
     */
    public final String trustAnchorId() {
        return trustAnchorId;
    }

    /**
     * <p>
     * The ISO-8601 timestamp when the trust anchor was last updated.
     * </p>
     * 
     * @return The ISO-8601 timestamp when the trust anchor was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(trustAnchorArn());
        hashCode = 31 * hashCode + Objects.hashCode(trustAnchorId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustAnchorDetail)) {
            return false;
        }
        TrustAnchorDetail other = (TrustAnchorDetail) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(name(), other.name()) && Objects.equals(source(), other.source())
                && Objects.equals(trustAnchorArn(), other.trustAnchorArn())
                && Objects.equals(trustAnchorId(), other.trustAnchorId()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustAnchorDetail").add("CreatedAt", createdAt()).add("Enabled", enabled()).add("Name", name())
                .add("Source", source()).add("TrustAnchorArn", trustAnchorArn()).add("TrustAnchorId", trustAnchorId())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "trustAnchorArn":
            return Optional.ofNullable(clazz.cast(trustAnchorArn()));
        case "trustAnchorId":
            return Optional.ofNullable(clazz.cast(trustAnchorId()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustAnchorDetail, T> g) {
        return obj -> g.apply((TrustAnchorDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustAnchorDetail> {
        /**
         * <p>
         * The ISO-8601 timestamp when the trust anchor was created.
         * </p>
         * 
         * @param createdAt
         *        The ISO-8601 timestamp when the trust anchor was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Indicates whether the trust anchor is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the trust anchor is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the trust anchor.
         * </p>
         * 
         * @param name
         *        The name of the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The trust anchor type and its related certificate data.
         * </p>
         * 
         * @param source
         *        The trust anchor type and its related certificate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The trust anchor type and its related certificate data.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The ARN of the trust anchor.
         * </p>
         * 
         * @param trustAnchorArn
         *        The ARN of the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustAnchorArn(String trustAnchorArn);

        /**
         * <p>
         * The unique identifier of the trust anchor.
         * </p>
         * 
         * @param trustAnchorId
         *        The unique identifier of the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustAnchorId(String trustAnchorId);

        /**
         * <p>
         * The ISO-8601 timestamp when the trust anchor was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The ISO-8601 timestamp when the trust anchor was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Boolean enabled;

        private String name;

        private Source source;

        private String trustAnchorArn;

        private String trustAnchorId;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustAnchorDetail model) {
            createdAt(model.createdAt);
            enabled(model.enabled);
            name(model.name);
            source(model.source);
            trustAnchorArn(model.trustAnchorArn);
            trustAnchorId(model.trustAnchorId);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final String getTrustAnchorArn() {
            return trustAnchorArn;
        }

        public final void setTrustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
        }

        @Override
        public final Builder trustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
            return this;
        }

        public final String getTrustAnchorId() {
            return trustAnchorId;
        }

        public final void setTrustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
        }

        @Override
        public final Builder trustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public TrustAnchorDetail build() {
            return new TrustAnchorDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
