/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCrlRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<DeleteCrlRequest.Builder, DeleteCrlRequest> {
    private static final SdkField<String> CRL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("crlId")
            .getter(getter(DeleteCrlRequest::crlId)).setter(setter(Builder::crlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("crlId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRL_ID_FIELD));

    private final String crlId;

    private DeleteCrlRequest(BuilderImpl builder) {
        super(builder);
        this.crlId = builder.crlId;
    }

    /**
     * <p>
     * The unique identifier of the certificate revocation list (CRL).
     * </p>
     * 
     * @return The unique identifier of the certificate revocation list (CRL).
     */
    public final String crlId() {
        return crlId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crlId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCrlRequest)) {
            return false;
        }
        DeleteCrlRequest other = (DeleteCrlRequest) obj;
        return Objects.equals(crlId(), other.crlId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCrlRequest").add("CrlId", crlId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crlId":
            return Optional.ofNullable(clazz.cast(crlId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCrlRequest, T> g) {
        return obj -> g.apply((DeleteCrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCrlRequest> {
        /**
         * <p>
         * The unique identifier of the certificate revocation list (CRL).
         * </p>
         * 
         * @param crlId
         *        The unique identifier of the certificate revocation list (CRL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crlId(String crlId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private String crlId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCrlRequest model) {
            super(model);
            crlId(model.crlId);
        }

        public final String getCrlId() {
            return crlId;
        }

        public final void setCrlId(String crlId) {
            this.crlId = crlId;
        }

        @Override
        public final Builder crlId(String crlId) {
            this.crlId = crlId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCrlRequest build() {
            return new DeleteCrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
