/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationEvent {
    CA_CERTIFICATE_EXPIRY("CA_CERTIFICATE_EXPIRY"),
    END_ENTITY_CERTIFICATE_EXPIRY("END_ENTITY_CERTIFICATE_EXPIRY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationEvent> VALUE_MAP;
    private final String value;

    private NotificationEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationEvent> knownValues() {
        EnumSet<NotificationEvent> knownValues = EnumSet.allOf(NotificationEvent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationEvent.class, NotificationEvent::toString);
    }
}

