/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProfileRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<UpdateProfileRequest.Builder, UpdateProfileRequest> {
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("durationSeconds").getter(getter(UpdateProfileRequest::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()).build();

    private static final SdkField<List<String>> MANAGED_POLICY_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("managedPolicyArns")
            .getter(getter(UpdateProfileRequest::managedPolicyArns))
            .setter(setter(Builder::managedPolicyArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedPolicyArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(UpdateProfileRequest::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileId").build()).build();

    private static final SdkField<List<String>> ROLE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("roleArns")
            .getter(getter(UpdateProfileRequest::roleArns))
            .setter(setter(Builder::roleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SESSION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionPolicy").getter(getter(UpdateProfileRequest::sessionPolicy))
            .setter(setter(Builder::sessionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_SECONDS_FIELD,
            MANAGED_POLICY_ARNS_FIELD, NAME_FIELD, PROFILE_ID_FIELD, ROLE_ARNS_FIELD, SESSION_POLICY_FIELD));

    private final Integer durationSeconds;

    private final List<String> managedPolicyArns;

    private final String name;

    private final String profileId;

    private final List<String> roleArns;

    private final String sessionPolicy;

    private UpdateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.durationSeconds = builder.durationSeconds;
        this.managedPolicyArns = builder.managedPolicyArns;
        this.name = builder.name;
        this.profileId = builder.profileId;
        this.roleArns = builder.roleArns;
        this.sessionPolicy = builder.sessionPolicy;
    }

    /**
     * <p>
     * Used to determine how long sessions vended using this profile are valid for. See the <code>Expiration</code>
     * section of the <a href=
     * "https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object"
     * >CreateSession API documentation</a> page for more details.
     * </p>
     * 
     * @return Used to determine how long sessions vended using this profile are valid for. See the
     *         <code>Expiration</code> section of the <a href=
     *         "https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object"
     *         >CreateSession API documentation</a> page for more details.
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedPolicyArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedPolicyArns() {
        return managedPolicyArns != null && !(managedPolicyArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of managed policy ARNs that apply to the vended session credentials.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedPolicyArns} method.
     * </p>
     * 
     * @return A list of managed policy ARNs that apply to the vended session credentials.
     */
    public final List<String> managedPolicyArns() {
        return managedPolicyArns;
    }

    /**
     * <p>
     * The name of the profile.
     * </p>
     * 
     * @return The name of the profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier of the profile.
     * </p>
     * 
     * @return The unique identifier of the profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoleArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoleArns() {
        return roleArns != null && !(roleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM roles that this profile can assume in a temporary credential request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoleArns} method.
     * </p>
     * 
     * @return A list of IAM roles that this profile can assume in a temporary credential request.
     */
    public final List<String> roleArns() {
        return roleArns;
    }

    /**
     * <p>
     * A session policy that applies to the trust boundary of the vended session credentials.
     * </p>
     * 
     * @return A session policy that applies to the trust boundary of the vended session credentials.
     */
    public final String sessionPolicy() {
        return sessionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedPolicyArns() ? managedPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoleArns() ? roleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileRequest)) {
            return false;
        }
        UpdateProfileRequest other = (UpdateProfileRequest) obj;
        return Objects.equals(durationSeconds(), other.durationSeconds())
                && hasManagedPolicyArns() == other.hasManagedPolicyArns()
                && Objects.equals(managedPolicyArns(), other.managedPolicyArns()) && Objects.equals(name(), other.name())
                && Objects.equals(profileId(), other.profileId()) && hasRoleArns() == other.hasRoleArns()
                && Objects.equals(roleArns(), other.roleArns()) && Objects.equals(sessionPolicy(), other.sessionPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProfileRequest").add("DurationSeconds", durationSeconds())
                .add("ManagedPolicyArns", hasManagedPolicyArns() ? managedPolicyArns() : null).add("Name", name())
                .add("ProfileId", profileId()).add("RoleArns", hasRoleArns() ? roleArns() : null)
                .add("SessionPolicy", sessionPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "durationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "managedPolicyArns":
            return Optional.ofNullable(clazz.cast(managedPolicyArns()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "roleArns":
            return Optional.ofNullable(clazz.cast(roleArns()));
        case "sessionPolicy":
            return Optional.ofNullable(clazz.cast(sessionPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileRequest, T> g) {
        return obj -> g.apply((UpdateProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProfileRequest> {
        /**
         * <p>
         * Used to determine how long sessions vended using this profile are valid for. See the <code>Expiration</code>
         * section of the <a href=
         * "https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object"
         * >CreateSession API documentation</a> page for more details.
         * </p>
         * 
         * @param durationSeconds
         *        Used to determine how long sessions vended using this profile are valid for. See the
         *        <code>Expiration</code> section of the <a href=
         *        "https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object"
         *        >CreateSession API documentation</a> page for more details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * A list of managed policy ARNs that apply to the vended session credentials.
         * </p>
         * 
         * @param managedPolicyArns
         *        A list of managed policy ARNs that apply to the vended session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedPolicyArns(Collection<String> managedPolicyArns);

        /**
         * <p>
         * A list of managed policy ARNs that apply to the vended session credentials.
         * </p>
         * 
         * @param managedPolicyArns
         *        A list of managed policy ARNs that apply to the vended session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedPolicyArns(String... managedPolicyArns);

        /**
         * <p>
         * The name of the profile.
         * </p>
         * 
         * @param name
         *        The name of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier of the profile.
         * </p>
         * 
         * @param profileId
         *        The unique identifier of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * A list of IAM roles that this profile can assume in a temporary credential request.
         * </p>
         * 
         * @param roleArns
         *        A list of IAM roles that this profile can assume in a temporary credential request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(Collection<String> roleArns);

        /**
         * <p>
         * A list of IAM roles that this profile can assume in a temporary credential request.
         * </p>
         * 
         * @param roleArns
         *        A list of IAM roles that this profile can assume in a temporary credential request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(String... roleArns);

        /**
         * <p>
         * A session policy that applies to the trust boundary of the vended session credentials.
         * </p>
         * 
         * @param sessionPolicy
         *        A session policy that applies to the trust boundary of the vended session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionPolicy(String sessionPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private Integer durationSeconds;

        private List<String> managedPolicyArns = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String profileId;

        private List<String> roleArns = DefaultSdkAutoConstructList.getInstance();

        private String sessionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileRequest model) {
            super(model);
            durationSeconds(model.durationSeconds);
            managedPolicyArns(model.managedPolicyArns);
            name(model.name);
            profileId(model.profileId);
            roleArns(model.roleArns);
            sessionPolicy(model.sessionPolicy);
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final Collection<String> getManagedPolicyArns() {
            if (managedPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return managedPolicyArns;
        }

        public final void setManagedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
        }

        @Override
        public final Builder managedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedPolicyArns(String... managedPolicyArns) {
            managedPolicyArns(Arrays.asList(managedPolicyArns));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final Collection<String> getRoleArns() {
            if (roleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return roleArns;
        }

        public final void setRoleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
        }

        @Override
        public final Builder roleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleArns(String... roleArns) {
            roleArns(Arrays.asList(roleArns));
            return this;
        }

        public final String getSessionPolicy() {
            return sessionPolicy;
        }

        public final void setSessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
        }

        @Override
        public final Builder sessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileRequest build() {
            return new UpdateProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
