/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAttributeMappingRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<DeleteAttributeMappingRequest.Builder, DeleteAttributeMappingRequest> {
    private static final SdkField<String> CERTIFICATE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateField").getter(getter(DeleteAttributeMappingRequest::certificateFieldAsString))
            .setter(setter(Builder::certificateField))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("certificateField").build())
            .build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(DeleteAttributeMappingRequest::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileId").build()).build();

    private static final SdkField<List<String>> SPECIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("specifiers")
            .getter(getter(DeleteAttributeMappingRequest::specifiers))
            .setter(setter(Builder::specifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("specifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD_FIELD,
            PROFILE_ID_FIELD, SPECIFIERS_FIELD));

    private final String certificateField;

    private final String profileId;

    private final List<String> specifiers;

    private DeleteAttributeMappingRequest(BuilderImpl builder) {
        super(builder);
        this.certificateField = builder.certificateField;
        this.profileId = builder.profileId;
        this.specifiers = builder.specifiers;
    }

    /**
     * <p>
     * Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateField}
     * will return {@link CertificateField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #certificateFieldAsString}.
     * </p>
     * 
     * @return Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
     * @see CertificateField
     */
    public final CertificateField certificateField() {
        return CertificateField.fromValue(certificateField);
    }

    /**
     * <p>
     * Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateField}
     * will return {@link CertificateField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #certificateFieldAsString}.
     * </p>
     * 
     * @return Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
     * @see CertificateField
     */
    public final String certificateFieldAsString() {
        return certificateField;
    }

    /**
     * <p>
     * The unique identifier of the profile.
     * </p>
     * 
     * @return The unique identifier of the profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Specifiers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSpecifiers() {
        return specifiers != null && !(specifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of specifiers of a certificate field; for example, CN, OU, UID from a Subject.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpecifiers} method.
     * </p>
     * 
     * @return A list of specifiers of a certificate field; for example, CN, OU, UID from a Subject.
     */
    public final List<String> specifiers() {
        return specifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateFieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpecifiers() ? specifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAttributeMappingRequest)) {
            return false;
        }
        DeleteAttributeMappingRequest other = (DeleteAttributeMappingRequest) obj;
        return Objects.equals(certificateFieldAsString(), other.certificateFieldAsString())
                && Objects.equals(profileId(), other.profileId()) && hasSpecifiers() == other.hasSpecifiers()
                && Objects.equals(specifiers(), other.specifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAttributeMappingRequest").add("CertificateField", certificateFieldAsString())
                .add("ProfileId", profileId()).add("Specifiers", hasSpecifiers() ? specifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateField":
            return Optional.ofNullable(clazz.cast(certificateFieldAsString()));
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "specifiers":
            return Optional.ofNullable(clazz.cast(specifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAttributeMappingRequest, T> g) {
        return obj -> g.apply((DeleteAttributeMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAttributeMappingRequest> {
        /**
         * <p>
         * Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
         * </p>
         * 
         * @param certificateField
         *        Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
         * @see CertificateField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateField
         */
        Builder certificateField(String certificateField);

        /**
         * <p>
         * Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
         * </p>
         * 
         * @param certificateField
         *        Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
         * @see CertificateField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateField
         */
        Builder certificateField(CertificateField certificateField);

        /**
         * <p>
         * The unique identifier of the profile.
         * </p>
         * 
         * @param profileId
         *        The unique identifier of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * A list of specifiers of a certificate field; for example, CN, OU, UID from a Subject.
         * </p>
         * 
         * @param specifiers
         *        A list of specifiers of a certificate field; for example, CN, OU, UID from a Subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specifiers(Collection<String> specifiers);

        /**
         * <p>
         * A list of specifiers of a certificate field; for example, CN, OU, UID from a Subject.
         * </p>
         * 
         * @param specifiers
         *        A list of specifiers of a certificate field; for example, CN, OU, UID from a Subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specifiers(String... specifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private String certificateField;

        private String profileId;

        private List<String> specifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAttributeMappingRequest model) {
            super(model);
            certificateField(model.certificateField);
            profileId(model.profileId);
            specifiers(model.specifiers);
        }

        public final String getCertificateField() {
            return certificateField;
        }

        public final void setCertificateField(String certificateField) {
            this.certificateField = certificateField;
        }

        @Override
        public final Builder certificateField(String certificateField) {
            this.certificateField = certificateField;
            return this;
        }

        @Override
        public final Builder certificateField(CertificateField certificateField) {
            this.certificateField(certificateField == null ? null : certificateField.toString());
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final Collection<String> getSpecifiers() {
            if (specifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return specifiers;
        }

        public final void setSpecifiers(Collection<String> specifiers) {
            this.specifiers = SpecifierListCopier.copy(specifiers);
        }

        @Override
        public final Builder specifiers(Collection<String> specifiers) {
            this.specifiers = SpecifierListCopier.copy(specifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder specifiers(String... specifiers) {
            specifiers(Arrays.asList(specifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAttributeMappingRequest build() {
            return new DeleteAttributeMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
