/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A record of a presented X509 credential from a temporary credential request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CredentialSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CredentialSummary.Builder, CredentialSummary> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(CredentialSummary::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Boolean> FAILED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("failed").getter(getter(CredentialSummary::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("issuer")
            .getter(getter(CredentialSummary::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()).build();

    private static final SdkField<Instant> SEEN_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("seenAt")
            .getter(getter(CredentialSummary::seenAt))
            .setter(setter(Builder::seenAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seenAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serialNumber").getter(getter(CredentialSummary::serialNumber)).setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()).build();

    private static final SdkField<String> X509_CERTIFICATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("x509CertificateData").getter(getter(CredentialSummary::x509CertificateData))
            .setter(setter(Builder::x509CertificateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x509CertificateData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, FAILED_FIELD,
            ISSUER_FIELD, SEEN_AT_FIELD, SERIAL_NUMBER_FIELD, X509_CERTIFICATE_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("enabled", ENABLED_FIELD);
                    put("failed", FAILED_FIELD);
                    put("issuer", ISSUER_FIELD);
                    put("seenAt", SEEN_AT_FIELD);
                    put("serialNumber", SERIAL_NUMBER_FIELD);
                    put("x509CertificateData", X509_CERTIFICATE_DATA_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Boolean failed;

    private final String issuer;

    private final Instant seenAt;

    private final String serialNumber;

    private final String x509CertificateData;

    private CredentialSummary(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.failed = builder.failed;
        this.issuer = builder.issuer;
        this.seenAt = builder.seenAt;
        this.serialNumber = builder.serialNumber;
        this.x509CertificateData = builder.x509CertificateData;
    }

    /**
     * <p>
     * Indicates whether the credential is enabled.
     * </p>
     * 
     * @return Indicates whether the credential is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Indicates whether the temporary credential request was successful.
     * </p>
     * 
     * @return Indicates whether the temporary credential request was successful.
     */
    public final Boolean failed() {
        return failed;
    }

    /**
     * <p>
     * The fully qualified domain name of the issuing certificate for the presented end-entity certificate.
     * </p>
     * 
     * @return The fully qualified domain name of the issuing certificate for the presented end-entity certificate.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
     * </p>
     * 
     * @return The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
     */
    public final Instant seenAt() {
        return seenAt;
    }

    /**
     * <p>
     * The serial number of the certificate.
     * </p>
     * 
     * @return The serial number of the certificate.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The PEM-encoded data of the certificate.
     * </p>
     * 
     * @return The PEM-encoded data of the certificate.
     */
    public final String x509CertificateData() {
        return x509CertificateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(seenAt());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(x509CertificateData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialSummary)) {
            return false;
        }
        CredentialSummary other = (CredentialSummary) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(failed(), other.failed())
                && Objects.equals(issuer(), other.issuer()) && Objects.equals(seenAt(), other.seenAt())
                && Objects.equals(serialNumber(), other.serialNumber())
                && Objects.equals(x509CertificateData(), other.x509CertificateData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CredentialSummary").add("Enabled", enabled()).add("Failed", failed()).add("Issuer", issuer())
                .add("SeenAt", seenAt()).add("SerialNumber", serialNumber()).add("X509CertificateData", x509CertificateData())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "seenAt":
            return Optional.ofNullable(clazz.cast(seenAt()));
        case "serialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "x509CertificateData":
            return Optional.ofNullable(clazz.cast(x509CertificateData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CredentialSummary, T> g) {
        return obj -> g.apply((CredentialSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CredentialSummary> {
        /**
         * <p>
         * Indicates whether the credential is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the credential is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Indicates whether the temporary credential request was successful.
         * </p>
         * 
         * @param failed
         *        Indicates whether the temporary credential request was successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Boolean failed);

        /**
         * <p>
         * The fully qualified domain name of the issuing certificate for the presented end-entity certificate.
         * </p>
         * 
         * @param issuer
         *        The fully qualified domain name of the issuing certificate for the presented end-entity certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
         * </p>
         * 
         * @param seenAt
         *        The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seenAt(Instant seenAt);

        /**
         * <p>
         * The serial number of the certificate.
         * </p>
         * 
         * @param serialNumber
         *        The serial number of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The PEM-encoded data of the certificate.
         * </p>
         * 
         * @param x509CertificateData
         *        The PEM-encoded data of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x509CertificateData(String x509CertificateData);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Boolean failed;

        private String issuer;

        private Instant seenAt;

        private String serialNumber;

        private String x509CertificateData;

        private BuilderImpl() {
        }

        private BuilderImpl(CredentialSummary model) {
            enabled(model.enabled);
            failed(model.failed);
            issuer(model.issuer);
            seenAt(model.seenAt);
            serialNumber(model.serialNumber);
            x509CertificateData(model.x509CertificateData);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getFailed() {
            return failed;
        }

        public final void setFailed(Boolean failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Boolean failed) {
            this.failed = failed;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final Instant getSeenAt() {
            return seenAt;
        }

        public final void setSeenAt(Instant seenAt) {
            this.seenAt = seenAt;
        }

        @Override
        public final Builder seenAt(Instant seenAt) {
            this.seenAt = seenAt;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getX509CertificateData() {
            return x509CertificateData;
        }

        public final void setX509CertificateData(String x509CertificateData) {
            this.x509CertificateData = x509CertificateData;
        }

        @Override
        public final Builder x509CertificateData(String x509CertificateData) {
            this.x509CertificateData = x509CertificateData;
            return this;
        }

        @Override
        public CredentialSummary build() {
            return new CredentialSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
