/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A notification setting key to reset. A notification setting key includes the event and the channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationSettingKey implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationSettingKey.Builder, NotificationSettingKey> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("channel")
            .getter(getter(NotificationSettingKey::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("event")
            .getter(getter(NotificationSettingKey::eventAsString)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, EVENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("channel", CHANNEL_FIELD);
                    put("event", EVENT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String channel;

    private final String event;

    private NotificationSettingKey(BuilderImpl builder) {
        this.channel = builder.channel;
        this.event = builder.event;
    }

    /**
     * <p>
     * The specified channel of notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link NotificationChannel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelAsString}.
     * </p>
     * 
     * @return The specified channel of notification.
     * @see NotificationChannel
     */
    public final NotificationChannel channel() {
        return NotificationChannel.fromValue(channel);
    }

    /**
     * <p>
     * The specified channel of notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link NotificationChannel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelAsString}.
     * </p>
     * 
     * @return The specified channel of notification.
     * @see NotificationChannel
     */
    public final String channelAsString() {
        return channel;
    }

    /**
     * <p>
     * The notification setting event to reset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link NotificationEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The notification setting event to reset.
     * @see NotificationEvent
     */
    public final NotificationEvent event() {
        return NotificationEvent.fromValue(event);
    }

    /**
     * <p>
     * The notification setting event to reset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link NotificationEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The notification setting event to reset.
     * @see NotificationEvent
     */
    public final String eventAsString() {
        return event;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationSettingKey)) {
            return false;
        }
        NotificationSettingKey other = (NotificationSettingKey) obj;
        return Objects.equals(channelAsString(), other.channelAsString())
                && Objects.equals(eventAsString(), other.eventAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationSettingKey").add("Channel", channelAsString()).add("Event", eventAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        case "event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NotificationSettingKey, T> g) {
        return obj -> g.apply((NotificationSettingKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationSettingKey> {
        /**
         * <p>
         * The specified channel of notification.
         * </p>
         * 
         * @param channel
         *        The specified channel of notification.
         * @see NotificationChannel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationChannel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The specified channel of notification.
         * </p>
         * 
         * @param channel
         *        The specified channel of notification.
         * @see NotificationChannel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationChannel
         */
        Builder channel(NotificationChannel channel);

        /**
         * <p>
         * The notification setting event to reset.
         * </p>
         * 
         * @param event
         *        The notification setting event to reset.
         * @see NotificationEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationEvent
         */
        Builder event(String event);

        /**
         * <p>
         * The notification setting event to reset.
         * </p>
         * 
         * @param event
         *        The notification setting event to reset.
         * @see NotificationEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationEvent
         */
        Builder event(NotificationEvent event);
    }

    static final class BuilderImpl implements Builder {
        private String channel;

        private String event;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationSettingKey model) {
            channel(model.channel);
            event(model.event);
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(NotificationChannel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final String getEvent() {
            return event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(NotificationEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        @Override
        public NotificationSettingKey build() {
            return new NotificationSettingKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
