/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutNotificationSettingsRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<PutNotificationSettingsRequest.Builder, PutNotificationSettingsRequest> {
    private static final SdkField<List<NotificationSetting>> NOTIFICATION_SETTINGS_FIELD = SdkField
            .<List<NotificationSetting>> builder(MarshallingType.LIST)
            .memberName("notificationSettings")
            .getter(getter(PutNotificationSettingsRequest::notificationSettings))
            .setter(setter(Builder::notificationSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRUST_ANCHOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustAnchorId").getter(getter(PutNotificationSettingsRequest::trustAnchorId))
            .setter(setter(Builder::trustAnchorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_SETTINGS_FIELD,
            TRUST_ANCHOR_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("notificationSettings", NOTIFICATION_SETTINGS_FIELD);
                    put("trustAnchorId", TRUST_ANCHOR_ID_FIELD);
                }
            });

    private final List<NotificationSetting> notificationSettings;

    private final String trustAnchorId;

    private PutNotificationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.notificationSettings = builder.notificationSettings;
        this.trustAnchorId = builder.trustAnchorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationSettings() {
        return notificationSettings != null && !(notificationSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of notification settings to be associated to the trust anchor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationSettings} method.
     * </p>
     * 
     * @return A list of notification settings to be associated to the trust anchor.
     */
    public final List<NotificationSetting> notificationSettings() {
        return notificationSettings;
    }

    /**
     * <p>
     * The unique identifier of the trust anchor.
     * </p>
     * 
     * @return The unique identifier of the trust anchor.
     */
    public final String trustAnchorId() {
        return trustAnchorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationSettings() ? notificationSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trustAnchorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutNotificationSettingsRequest)) {
            return false;
        }
        PutNotificationSettingsRequest other = (PutNotificationSettingsRequest) obj;
        return hasNotificationSettings() == other.hasNotificationSettings()
                && Objects.equals(notificationSettings(), other.notificationSettings())
                && Objects.equals(trustAnchorId(), other.trustAnchorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutNotificationSettingsRequest")
                .add("NotificationSettings", hasNotificationSettings() ? notificationSettings() : null)
                .add("TrustAnchorId", trustAnchorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationSettings":
            return Optional.ofNullable(clazz.cast(notificationSettings()));
        case "trustAnchorId":
            return Optional.ofNullable(clazz.cast(trustAnchorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutNotificationSettingsRequest, T> g) {
        return obj -> g.apply((PutNotificationSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutNotificationSettingsRequest> {
        /**
         * <p>
         * A list of notification settings to be associated to the trust anchor.
         * </p>
         * 
         * @param notificationSettings
         *        A list of notification settings to be associated to the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSettings(Collection<NotificationSetting> notificationSettings);

        /**
         * <p>
         * A list of notification settings to be associated to the trust anchor.
         * </p>
         * 
         * @param notificationSettings
         *        A list of notification settings to be associated to the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSettings(NotificationSetting... notificationSettings);

        /**
         * <p>
         * A list of notification settings to be associated to the trust anchor.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationSettings(List<NotificationSetting>)}.
         * 
         * @param notificationSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationSettings(java.util.Collection<NotificationSetting>)
         */
        Builder notificationSettings(Consumer<NotificationSetting.Builder>... notificationSettings);

        /**
         * <p>
         * The unique identifier of the trust anchor.
         * </p>
         * 
         * @param trustAnchorId
         *        The unique identifier of the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustAnchorId(String trustAnchorId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private List<NotificationSetting> notificationSettings = DefaultSdkAutoConstructList.getInstance();

        private String trustAnchorId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutNotificationSettingsRequest model) {
            super(model);
            notificationSettings(model.notificationSettings);
            trustAnchorId(model.trustAnchorId);
        }

        public final List<NotificationSetting.Builder> getNotificationSettings() {
            List<NotificationSetting.Builder> result = NotificationSettingsCopier.copyToBuilder(this.notificationSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationSettings(Collection<NotificationSetting.BuilderImpl> notificationSettings) {
            this.notificationSettings = NotificationSettingsCopier.copyFromBuilder(notificationSettings);
        }

        @Override
        public final Builder notificationSettings(Collection<NotificationSetting> notificationSettings) {
            this.notificationSettings = NotificationSettingsCopier.copy(notificationSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(NotificationSetting... notificationSettings) {
            notificationSettings(Arrays.asList(notificationSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(Consumer<NotificationSetting.Builder>... notificationSettings) {
            notificationSettings(Stream.of(notificationSettings).map(c -> NotificationSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTrustAnchorId() {
            return trustAnchorId;
        }

        public final void setTrustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
        }

        @Override
        public final Builder trustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutNotificationSettingsRequest build() {
            return new PutNotificationSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
