/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetNotificationSettingsRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<ResetNotificationSettingsRequest.Builder, ResetNotificationSettingsRequest> {
    private static final SdkField<List<NotificationSettingKey>> NOTIFICATION_SETTING_KEYS_FIELD = SdkField
            .<List<NotificationSettingKey>> builder(MarshallingType.LIST)
            .memberName("notificationSettingKeys")
            .getter(getter(ResetNotificationSettingsRequest::notificationSettingKeys))
            .setter(setter(Builder::notificationSettingKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSettingKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationSettingKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationSettingKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRUST_ANCHOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustAnchorId").getter(getter(ResetNotificationSettingsRequest::trustAnchorId))
            .setter(setter(Builder::trustAnchorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NOTIFICATION_SETTING_KEYS_FIELD, TRUST_ANCHOR_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("notificationSettingKeys", NOTIFICATION_SETTING_KEYS_FIELD);
                    put("trustAnchorId", TRUST_ANCHOR_ID_FIELD);
                }
            });

    private final List<NotificationSettingKey> notificationSettingKeys;

    private final String trustAnchorId;

    private ResetNotificationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.notificationSettingKeys = builder.notificationSettingKeys;
        this.trustAnchorId = builder.trustAnchorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationSettingKeys property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNotificationSettingKeys() {
        return notificationSettingKeys != null && !(notificationSettingKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of notification setting keys to reset. A notification setting key includes the event and the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationSettingKeys} method.
     * </p>
     * 
     * @return A list of notification setting keys to reset. A notification setting key includes the event and the
     *         channel.
     */
    public final List<NotificationSettingKey> notificationSettingKeys() {
        return notificationSettingKeys;
    }

    /**
     * <p>
     * The unique identifier of the trust anchor.
     * </p>
     * 
     * @return The unique identifier of the trust anchor.
     */
    public final String trustAnchorId() {
        return trustAnchorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationSettingKeys() ? notificationSettingKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trustAnchorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetNotificationSettingsRequest)) {
            return false;
        }
        ResetNotificationSettingsRequest other = (ResetNotificationSettingsRequest) obj;
        return hasNotificationSettingKeys() == other.hasNotificationSettingKeys()
                && Objects.equals(notificationSettingKeys(), other.notificationSettingKeys())
                && Objects.equals(trustAnchorId(), other.trustAnchorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResetNotificationSettingsRequest")
                .add("NotificationSettingKeys", hasNotificationSettingKeys() ? notificationSettingKeys() : null)
                .add("TrustAnchorId", trustAnchorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationSettingKeys":
            return Optional.ofNullable(clazz.cast(notificationSettingKeys()));
        case "trustAnchorId":
            return Optional.ofNullable(clazz.cast(trustAnchorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResetNotificationSettingsRequest, T> g) {
        return obj -> g.apply((ResetNotificationSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ResetNotificationSettingsRequest> {
        /**
         * <p>
         * A list of notification setting keys to reset. A notification setting key includes the event and the channel.
         * </p>
         * 
         * @param notificationSettingKeys
         *        A list of notification setting keys to reset. A notification setting key includes the event and the
         *        channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSettingKeys(Collection<NotificationSettingKey> notificationSettingKeys);

        /**
         * <p>
         * A list of notification setting keys to reset. A notification setting key includes the event and the channel.
         * </p>
         * 
         * @param notificationSettingKeys
         *        A list of notification setting keys to reset. A notification setting key includes the event and the
         *        channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSettingKeys(NotificationSettingKey... notificationSettingKeys);

        /**
         * <p>
         * A list of notification setting keys to reset. A notification setting key includes the event and the channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingKey.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingKey.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationSettingKeys(List<NotificationSettingKey>)}.
         * 
         * @param notificationSettingKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationSettingKeys(java.util.Collection<NotificationSettingKey>)
         */
        Builder notificationSettingKeys(Consumer<NotificationSettingKey.Builder>... notificationSettingKeys);

        /**
         * <p>
         * The unique identifier of the trust anchor.
         * </p>
         * 
         * @param trustAnchorId
         *        The unique identifier of the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustAnchorId(String trustAnchorId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private List<NotificationSettingKey> notificationSettingKeys = DefaultSdkAutoConstructList.getInstance();

        private String trustAnchorId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetNotificationSettingsRequest model) {
            super(model);
            notificationSettingKeys(model.notificationSettingKeys);
            trustAnchorId(model.trustAnchorId);
        }

        public final List<NotificationSettingKey.Builder> getNotificationSettingKeys() {
            List<NotificationSettingKey.Builder> result = NotificationSettingKeysCopier
                    .copyToBuilder(this.notificationSettingKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationSettingKeys(Collection<NotificationSettingKey.BuilderImpl> notificationSettingKeys) {
            this.notificationSettingKeys = NotificationSettingKeysCopier.copyFromBuilder(notificationSettingKeys);
        }

        @Override
        public final Builder notificationSettingKeys(Collection<NotificationSettingKey> notificationSettingKeys) {
            this.notificationSettingKeys = NotificationSettingKeysCopier.copy(notificationSettingKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettingKeys(NotificationSettingKey... notificationSettingKeys) {
            notificationSettingKeys(Arrays.asList(notificationSettingKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettingKeys(Consumer<NotificationSettingKey.Builder>... notificationSettingKeys) {
            notificationSettingKeys(Stream.of(notificationSettingKeys)
                    .map(c -> NotificationSettingKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrustAnchorId() {
            return trustAnchorId;
        }

        public final void setTrustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
        }

        @Override
        public final Builder trustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetNotificationSettingsRequest build() {
            return new ResetNotificationSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
