/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The trust anchor type and its related certificate data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Source implements SdkPojo, Serializable, ToCopyableBuilder<Source.Builder, Source> {
    private static final SdkField<SourceData> SOURCE_DATA_FIELD = SdkField.<SourceData> builder(MarshallingType.SDK_POJO)
            .memberName("sourceData").getter(getter(Source::sourceData)).setter(setter(Builder::sourceData))
            .constructor(SourceData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceData").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(Source::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DATA_FIELD,
            SOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("sourceData", SOURCE_DATA_FIELD);
                    put("sourceType", SOURCE_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final SourceData sourceData;

    private final String sourceType;

    private Source(BuilderImpl builder) {
        this.sourceData = builder.sourceData;
        this.sourceType = builder.sourceType;
    }

    /**
     * <p>
     * The data field of the trust anchor depending on its type.
     * </p>
     * 
     * @return The data field of the trust anchor depending on its type.
     */
    public final SourceData sourceData() {
        return sourceData;
    }

    /**
     * <p>
     * The type of the trust anchor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link TrustAnchorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of the trust anchor.
     * @see TrustAnchorType
     */
    public final TrustAnchorType sourceType() {
        return TrustAnchorType.fromValue(sourceType);
    }

    /**
     * <p>
     * The type of the trust anchor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link TrustAnchorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of the trust anchor.
     * @see TrustAnchorType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceData());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source) obj;
        return Objects.equals(sourceData(), other.sourceData())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Source").add("SourceData", sourceData()).add("SourceType", sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceData":
            return Optional.ofNullable(clazz.cast(sourceData()));
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Source> {
        /**
         * <p>
         * The data field of the trust anchor depending on its type.
         * </p>
         * 
         * @param sourceData
         *        The data field of the trust anchor depending on its type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceData(SourceData sourceData);

        /**
         * <p>
         * The data field of the trust anchor depending on its type.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceData.Builder} avoiding the need to
         * create one manually via {@link SourceData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceData.Builder#build()} is called immediately and its result
         * is passed to {@link #sourceData(SourceData)}.
         * 
         * @param sourceData
         *        a consumer that will call methods on {@link SourceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceData(SourceData)
         */
        default Builder sourceData(Consumer<SourceData.Builder> sourceData) {
            return sourceData(SourceData.builder().applyMutation(sourceData).build());
        }

        /**
         * <p>
         * The type of the trust anchor.
         * </p>
         * 
         * @param sourceType
         *        The type of the trust anchor.
         * @see TrustAnchorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustAnchorType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The type of the trust anchor.
         * </p>
         * 
         * @param sourceType
         *        The type of the trust anchor.
         * @see TrustAnchorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustAnchorType
         */
        Builder sourceType(TrustAnchorType sourceType);
    }

    static final class BuilderImpl implements Builder {
        private SourceData sourceData;

        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            sourceData(model.sourceData);
            sourceType(model.sourceType);
        }

        public final SourceData.Builder getSourceData() {
            return sourceData != null ? sourceData.toBuilder() : null;
        }

        public final void setSourceData(SourceData.BuilderImpl sourceData) {
            this.sourceData = sourceData != null ? sourceData.build() : null;
        }

        @Override
        public final Builder sourceData(SourceData sourceData) {
            this.sourceData = sourceData;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(TrustAnchorType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        @Override
        public Source build() {
            return new Source(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
