/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data field of the trust anchor depending on its type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceData implements SdkPojo, Serializable, ToCopyableBuilder<SourceData.Builder, SourceData> {
    private static final SdkField<String> ACM_PCA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acmPcaArn").getter(getter(SourceData::acmPcaArn)).setter(setter(Builder::acmPcaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acmPcaArn").build()).build();

    private static final SdkField<String> X509_CERTIFICATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("x509CertificateData").getter(getter(SourceData::x509CertificateData))
            .setter(setter(Builder::x509CertificateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x509CertificateData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_PCA_ARN_FIELD,
            X509_CERTIFICATE_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("acmPcaArn", ACM_PCA_ARN_FIELD);
                    put("x509CertificateData", X509_CERTIFICATE_DATA_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String acmPcaArn;

    private final String x509CertificateData;

    private final Type type;

    private SourceData(BuilderImpl builder) {
        this.acmPcaArn = builder.acmPcaArn;
        this.x509CertificateData = builder.x509CertificateData;
        this.type = builder.type;
    }

    /**
     * <p>
     * The root certificate of the Private Certificate Authority specified by this ARN is used in trust validation for
     * temporary credential requests. Included for trust anchors of type <code>AWS_ACM_PCA</code>.
     * </p>
     * 
     * @return The root certificate of the Private Certificate Authority specified by this ARN is used in trust
     *         validation for temporary credential requests. Included for trust anchors of type <code>AWS_ACM_PCA</code>
     *         .
     */
    public final String acmPcaArn() {
        return acmPcaArn;
    }

    /**
     * <p>
     * The PEM-encoded data for the certificate anchor. Included for trust anchors of type
     * <code>CERTIFICATE_BUNDLE</code>.
     * </p>
     * 
     * @return The PEM-encoded data for the certificate anchor. Included for trust anchors of type
     *         <code>CERTIFICATE_BUNDLE</code>.
     */
    public final String x509CertificateData() {
        return x509CertificateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acmPcaArn());
        hashCode = 31 * hashCode + Objects.hashCode(x509CertificateData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceData)) {
            return false;
        }
        SourceData other = (SourceData) obj;
        return Objects.equals(acmPcaArn(), other.acmPcaArn())
                && Objects.equals(x509CertificateData(), other.x509CertificateData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceData").add("AcmPcaArn", acmPcaArn()).add("X509CertificateData", x509CertificateData())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acmPcaArn":
            return Optional.ofNullable(clazz.cast(acmPcaArn()));
        case "x509CertificateData":
            return Optional.ofNullable(clazz.cast(x509CertificateData()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #acmPcaArn()} initialized to the given value.
     *
     * <p>
     * The root certificate of the Private Certificate Authority specified by this ARN is used in trust validation for
     * temporary credential requests. Included for trust anchors of type <code>AWS_ACM_PCA</code>.
     * </p>
     * 
     * @param acmPcaArn
     *        The root certificate of the Private Certificate Authority specified by this ARN is used in trust
     *        validation for temporary credential requests. Included for trust anchors of type <code>AWS_ACM_PCA</code>.
     */
    public static SourceData fromAcmPcaArn(String acmPcaArn) {
        return builder().acmPcaArn(acmPcaArn).build();
    }

    /**
     * Create an instance of this class with {@link #x509CertificateData()} initialized to the given value.
     *
     * <p>
     * The PEM-encoded data for the certificate anchor. Included for trust anchors of type
     * <code>CERTIFICATE_BUNDLE</code>.
     * </p>
     * 
     * @param x509CertificateData
     *        The PEM-encoded data for the certificate anchor. Included for trust anchors of type
     *        <code>CERTIFICATE_BUNDLE</code>.
     */
    public static SourceData fromX509CertificateData(String x509CertificateData) {
        return builder().x509CertificateData(x509CertificateData).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SourceData, T> g) {
        return obj -> g.apply((SourceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceData> {
        /**
         * <p>
         * The root certificate of the Private Certificate Authority specified by this ARN is used in trust validation
         * for temporary credential requests. Included for trust anchors of type <code>AWS_ACM_PCA</code>.
         * </p>
         * 
         * @param acmPcaArn
         *        The root certificate of the Private Certificate Authority specified by this ARN is used in trust
         *        validation for temporary credential requests. Included for trust anchors of type
         *        <code>AWS_ACM_PCA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acmPcaArn(String acmPcaArn);

        /**
         * <p>
         * The PEM-encoded data for the certificate anchor. Included for trust anchors of type
         * <code>CERTIFICATE_BUNDLE</code>.
         * </p>
         * 
         * @param x509CertificateData
         *        The PEM-encoded data for the certificate anchor. Included for trust anchors of type
         *        <code>CERTIFICATE_BUNDLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x509CertificateData(String x509CertificateData);
    }

    static final class BuilderImpl implements Builder {
        private String acmPcaArn;

        private String x509CertificateData;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SourceData model) {
            acmPcaArn(model.acmPcaArn);
            x509CertificateData(model.x509CertificateData);
        }

        public final String getAcmPcaArn() {
            return acmPcaArn;
        }

        public final void setAcmPcaArn(String acmPcaArn) {
            Object oldValue = this.acmPcaArn;
            this.acmPcaArn = acmPcaArn;
            handleUnionValueChange(Type.ACM_PCA_ARN, oldValue, this.acmPcaArn);
        }

        @Override
        public final Builder acmPcaArn(String acmPcaArn) {
            Object oldValue = this.acmPcaArn;
            this.acmPcaArn = acmPcaArn;
            handleUnionValueChange(Type.ACM_PCA_ARN, oldValue, this.acmPcaArn);
            return this;
        }

        public final String getX509CertificateData() {
            return x509CertificateData;
        }

        public final void setX509CertificateData(String x509CertificateData) {
            Object oldValue = this.x509CertificateData;
            this.x509CertificateData = x509CertificateData;
            handleUnionValueChange(Type.X509_CERTIFICATE_DATA, oldValue, this.x509CertificateData);
        }

        @Override
        public final Builder x509CertificateData(String x509CertificateData) {
            Object oldValue = this.x509CertificateData;
            this.x509CertificateData = x509CertificateData;
            handleUnionValueChange(Type.X509_CERTIFICATE_DATA, oldValue, this.x509CertificateData);
            return this;
        }

        @Override
        public SourceData build() {
            return new SourceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SourceData#type()
     */
    public enum Type {
        ACM_PCA_ARN,

        X509_CERTIFICATE_DATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
