/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrustAnchorRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<UpdateTrustAnchorRequest.Builder, UpdateTrustAnchorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateTrustAnchorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(UpdateTrustAnchorRequest::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TRUST_ANCHOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustAnchorId").getter(getter(UpdateTrustAnchorRequest::trustAnchorId))
            .setter(setter(Builder::trustAnchorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("trustAnchorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOURCE_FIELD,
            TRUST_ANCHOR_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("source", SOURCE_FIELD);
                    put("trustAnchorId", TRUST_ANCHOR_ID_FIELD);
                }
            });

    private final String name;

    private final Source source;

    private final String trustAnchorId;

    private UpdateTrustAnchorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.source = builder.source;
        this.trustAnchorId = builder.trustAnchorId;
    }

    /**
     * <p>
     * The name of the trust anchor.
     * </p>
     * 
     * @return The name of the trust anchor.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The trust anchor type and its related certificate data.
     * </p>
     * 
     * @return The trust anchor type and its related certificate data.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * The unique identifier of the trust anchor.
     * </p>
     * 
     * @return The unique identifier of the trust anchor.
     */
    public final String trustAnchorId() {
        return trustAnchorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(trustAnchorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustAnchorRequest)) {
            return false;
        }
        UpdateTrustAnchorRequest other = (UpdateTrustAnchorRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(source(), other.source())
                && Objects.equals(trustAnchorId(), other.trustAnchorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrustAnchorRequest").add("Name", name()).add("Source", source())
                .add("TrustAnchorId", trustAnchorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "trustAnchorId":
            return Optional.ofNullable(clazz.cast(trustAnchorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustAnchorRequest, T> g) {
        return obj -> g.apply((UpdateTrustAnchorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrustAnchorRequest> {
        /**
         * <p>
         * The name of the trust anchor.
         * </p>
         * 
         * @param name
         *        The name of the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The trust anchor type and its related certificate data.
         * </p>
         * 
         * @param source
         *        The trust anchor type and its related certificate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The trust anchor type and its related certificate data.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The unique identifier of the trust anchor.
         * </p>
         * 
         * @param trustAnchorId
         *        The unique identifier of the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustAnchorId(String trustAnchorId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private String name;

        private Source source;

        private String trustAnchorId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustAnchorRequest model) {
            super(model);
            name(model.name);
            source(model.source);
            trustAnchorId(model.trustAnchorId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final String getTrustAnchorId() {
            return trustAnchorId;
        }

        public final void setTrustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
        }

        @Override
        public final Builder trustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrustAnchorRequest build() {
            return new UpdateTrustAnchorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
