/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableCrlResponse extends RolesAnywhereResponse implements
        ToCopyableBuilder<EnableCrlResponse.Builder, EnableCrlResponse> {
    private static final SdkField<CrlDetail> CRL_FIELD = SdkField.<CrlDetail> builder(MarshallingType.SDK_POJO).memberName("crl")
            .getter(getter(EnableCrlResponse::crl)).setter(setter(Builder::crl)).constructor(CrlDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CrlDetail crl;

    private EnableCrlResponse(BuilderImpl builder) {
        super(builder);
        this.crl = builder.crl;
    }

    /**
     * <p>
     * The state of the certificate revocation list (CRL) after a read or write operation.
     * </p>
     * 
     * @return The state of the certificate revocation list (CRL) after a read or write operation.
     */
    public final CrlDetail crl() {
        return crl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableCrlResponse)) {
            return false;
        }
        EnableCrlResponse other = (EnableCrlResponse) obj;
        return Objects.equals(crl(), other.crl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableCrlResponse").add("Crl", crl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crl":
            return Optional.ofNullable(clazz.cast(crl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("crl", CRL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableCrlResponse, T> g) {
        return obj -> g.apply((EnableCrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereResponse.Builder, SdkPojo, CopyableBuilder<Builder, EnableCrlResponse> {
        /**
         * <p>
         * The state of the certificate revocation list (CRL) after a read or write operation.
         * </p>
         * 
         * @param crl
         *        The state of the certificate revocation list (CRL) after a read or write operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crl(CrlDetail crl);

        /**
         * <p>
         * The state of the certificate revocation list (CRL) after a read or write operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CrlDetail.Builder} avoiding the need to
         * create one manually via {@link CrlDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CrlDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #crl(CrlDetail)}.
         * 
         * @param crl
         *        a consumer that will call methods on {@link CrlDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crl(CrlDetail)
         */
        default Builder crl(Consumer<CrlDetail.Builder> crl) {
            return crl(CrlDetail.builder().applyMutation(crl).build());
        }
    }

    static final class BuilderImpl extends RolesAnywhereResponse.BuilderImpl implements Builder {
        private CrlDetail crl;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableCrlResponse model) {
            super(model);
            crl(model.crl);
        }

        public final CrlDetail.Builder getCrl() {
            return crl != null ? crl.toBuilder() : null;
        }

        public final void setCrl(CrlDetail.BuilderImpl crl) {
            this.crl = crl != null ? crl.build() : null;
        }

        @Override
        public final Builder crl(CrlDetail crl) {
            this.crl = crl;
            return this;
        }

        @Override
        public EnableCrlResponse build() {
            return new EnableCrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
