/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A key-value pair you set that identifies a property of the authenticating instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceProperty.Builder, InstanceProperty> {
    private static final SdkField<Boolean> FAILED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("failed").getter(getter(InstanceProperty::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("properties")
            .getter(getter(InstanceProperty::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> SEEN_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("seenAt")
            .getter(getter(InstanceProperty::seenAt))
            .setter(setter(Builder::seenAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seenAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD,
            PROPERTIES_FIELD, SEEN_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean failed;

    private final Map<String, String> properties;

    private final Instant seenAt;

    private InstanceProperty(BuilderImpl builder) {
        this.failed = builder.failed;
        this.properties = builder.properties;
        this.seenAt = builder.seenAt;
    }

    /**
     * <p>
     * Indicates whether the temporary credential request was successful.
     * </p>
     * 
     * @return Indicates whether the temporary credential request was successful.
     */
    public final Boolean failed() {
        return failed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of instanceProperty objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return A list of instanceProperty objects.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    /**
     * <p>
     * The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
     * </p>
     * 
     * @return The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
     */
    public final Instant seenAt() {
        return seenAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(seenAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProperty)) {
            return false;
        }
        InstanceProperty other = (InstanceProperty) obj;
        return Objects.equals(failed(), other.failed()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties()) && Objects.equals(seenAt(), other.seenAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceProperty").add("Failed", failed())
                .add("Properties", hasProperties() ? properties() : null).add("SeenAt", seenAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "seenAt":
            return Optional.ofNullable(clazz.cast(seenAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("failed", FAILED_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("seenAt", SEEN_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceProperty, T> g) {
        return obj -> g.apply((InstanceProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceProperty> {
        /**
         * <p>
         * Indicates whether the temporary credential request was successful.
         * </p>
         * 
         * @param failed
         *        Indicates whether the temporary credential request was successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Boolean failed);

        /**
         * <p>
         * A list of instanceProperty objects.
         * </p>
         * 
         * @param properties
         *        A list of instanceProperty objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);

        /**
         * <p>
         * The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
         * </p>
         * 
         * @param seenAt
         *        The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seenAt(Instant seenAt);
    }

    static final class BuilderImpl implements Builder {
        private Boolean failed;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private Instant seenAt;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceProperty model) {
            failed(model.failed);
            properties(model.properties);
            seenAt(model.seenAt);
        }

        public final Boolean getFailed() {
            return failed;
        }

        public final void setFailed(Boolean failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Boolean failed) {
            this.failed = failed;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = InstancePropertyMapCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = InstancePropertyMapCopier.copy(properties);
            return this;
        }

        public final Instant getSeenAt() {
            return seenAt;
        }

        public final void setSeenAt(Instant seenAt) {
            this.seenAt = seenAt;
        }

        @Override
        public final Builder seenAt(Instant seenAt) {
            this.seenAt = seenAt;
            return this;
        }

        @Override
        public InstanceProperty build() {
            return new InstanceProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
