/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrustAnchorResponse extends RolesAnywhereResponse implements
        ToCopyableBuilder<GetTrustAnchorResponse.Builder, GetTrustAnchorResponse> {
    private static final SdkField<TrustAnchorDetail> TRUST_ANCHOR_FIELD = SdkField
            .<TrustAnchorDetail> builder(MarshallingType.SDK_POJO).memberName("trustAnchor")
            .getter(getter(GetTrustAnchorResponse::trustAnchor)).setter(setter(Builder::trustAnchor))
            .constructor(TrustAnchorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_ANCHOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TrustAnchorDetail trustAnchor;

    private GetTrustAnchorResponse(BuilderImpl builder) {
        super(builder);
        this.trustAnchor = builder.trustAnchor;
    }

    /**
     * <p>
     * The state of the trust anchor after a read or write operation.
     * </p>
     * 
     * @return The state of the trust anchor after a read or write operation.
     */
    public final TrustAnchorDetail trustAnchor() {
        return trustAnchor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustAnchor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrustAnchorResponse)) {
            return false;
        }
        GetTrustAnchorResponse other = (GetTrustAnchorResponse) obj;
        return Objects.equals(trustAnchor(), other.trustAnchor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTrustAnchorResponse").add("TrustAnchor", trustAnchor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trustAnchor":
            return Optional.ofNullable(clazz.cast(trustAnchor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trustAnchor", TRUST_ANCHOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTrustAnchorResponse, T> g) {
        return obj -> g.apply((GetTrustAnchorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTrustAnchorResponse> {
        /**
         * <p>
         * The state of the trust anchor after a read or write operation.
         * </p>
         * 
         * @param trustAnchor
         *        The state of the trust anchor after a read or write operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustAnchor(TrustAnchorDetail trustAnchor);

        /**
         * <p>
         * The state of the trust anchor after a read or write operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustAnchorDetail.Builder} avoiding the
         * need to create one manually via {@link TrustAnchorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustAnchorDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #trustAnchor(TrustAnchorDetail)}.
         * 
         * @param trustAnchor
         *        a consumer that will call methods on {@link TrustAnchorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustAnchor(TrustAnchorDetail)
         */
        default Builder trustAnchor(Consumer<TrustAnchorDetail.Builder> trustAnchor) {
            return trustAnchor(TrustAnchorDetail.builder().applyMutation(trustAnchor).build());
        }
    }

    static final class BuilderImpl extends RolesAnywhereResponse.BuilderImpl implements Builder {
        private TrustAnchorDetail trustAnchor;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrustAnchorResponse model) {
            super(model);
            trustAnchor(model.trustAnchor);
        }

        public final TrustAnchorDetail.Builder getTrustAnchor() {
            return trustAnchor != null ? trustAnchor.toBuilder() : null;
        }

        public final void setTrustAnchor(TrustAnchorDetail.BuilderImpl trustAnchor) {
            this.trustAnchor = trustAnchor != null ? trustAnchor.build() : null;
        }

        @Override
        public final Builder trustAnchor(TrustAnchorDetail trustAnchor) {
            this.trustAnchor = trustAnchor;
            return this;
        }

        @Override
        public GetTrustAnchorResponse build() {
            return new GetTrustAnchorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
