/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSubjectsResponse extends RolesAnywhereResponse implements
        ToCopyableBuilder<ListSubjectsResponse.Builder, ListSubjectsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSubjectsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SubjectSummary>> SUBJECTS_FIELD = SdkField
            .<List<SubjectSummary>> builder(MarshallingType.LIST)
            .memberName("subjects")
            .getter(getter(ListSubjectsResponse::subjects))
            .setter(setter(Builder::subjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubjectSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubjectSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SUBJECTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<SubjectSummary> subjects;

    private ListSubjectsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.subjects = builder.subjects;
    }

    /**
     * <p>
     * A token that indicates where the output should continue from, if a previous request did not show all results. To
     * get the next results, make the request again with this value.
     * </p>
     * 
     * @return A token that indicates where the output should continue from, if a previous request did not show all
     *         results. To get the next results, make the request again with this value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subjects property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubjects() {
        return subjects != null && !(subjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subjects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubjects} method.
     * </p>
     * 
     * @return A list of subjects.
     */
    public final List<SubjectSummary> subjects() {
        return subjects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubjects() ? subjects() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubjectsResponse)) {
            return false;
        }
        ListSubjectsResponse other = (ListSubjectsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSubjects() == other.hasSubjects()
                && Objects.equals(subjects(), other.subjects());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSubjectsResponse").add("NextToken", nextToken())
                .add("Subjects", hasSubjects() ? subjects() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "subjects":
            return Optional.ofNullable(clazz.cast(subjects()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("subjects", SUBJECTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubjectsResponse, T> g) {
        return obj -> g.apply((ListSubjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSubjectsResponse> {
        /**
         * <p>
         * A token that indicates where the output should continue from, if a previous request did not show all results.
         * To get the next results, make the request again with this value.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where the output should continue from, if a previous request did not show all
         *        results. To get the next results, make the request again with this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of subjects.
         * </p>
         * 
         * @param subjects
         *        A list of subjects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjects(Collection<SubjectSummary> subjects);

        /**
         * <p>
         * A list of subjects.
         * </p>
         * 
         * @param subjects
         *        A list of subjects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjects(SubjectSummary... subjects);

        /**
         * <p>
         * A list of subjects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.SubjectSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rolesanywhere.model.SubjectSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.SubjectSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #subjects(List<SubjectSummary>)}.
         * 
         * @param subjects
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.SubjectSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subjects(java.util.Collection<SubjectSummary>)
         */
        Builder subjects(Consumer<SubjectSummary.Builder>... subjects);
    }

    static final class BuilderImpl extends RolesAnywhereResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SubjectSummary> subjects = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubjectsResponse model) {
            super(model);
            nextToken(model.nextToken);
            subjects(model.subjects);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SubjectSummary.Builder> getSubjects() {
            List<SubjectSummary.Builder> result = SubjectSummariesCopier.copyToBuilder(this.subjects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubjects(Collection<SubjectSummary.BuilderImpl> subjects) {
            this.subjects = SubjectSummariesCopier.copyFromBuilder(subjects);
        }

        @Override
        public final Builder subjects(Collection<SubjectSummary> subjects) {
            this.subjects = SubjectSummariesCopier.copy(subjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjects(SubjectSummary... subjects) {
            subjects(Arrays.asList(subjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjects(Consumer<SubjectSummary.Builder>... subjects) {
            subjects(Stream.of(subjects).map(c -> SubjectSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSubjectsResponse build() {
            return new ListSubjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
