/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of a notification setting.
 * </p>
 * <p>
 * A notification setting includes information such as event name, threshold, status of the notification setting, and
 * the channel to notify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationSettingDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationSettingDetail.Builder, NotificationSettingDetail> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("channel")
            .getter(getter(NotificationSettingDetail::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<String> CONFIGURED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredBy").getter(getter(NotificationSettingDetail::configuredBy))
            .setter(setter(Builder::configuredBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredBy").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(NotificationSettingDetail::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("event")
            .getter(getter(NotificationSettingDetail::eventAsString)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final SdkField<Integer> THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("threshold").getter(getter(NotificationSettingDetail::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD,
            CONFIGURED_BY_FIELD, ENABLED_FIELD, EVENT_FIELD, THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channel;

    private final String configuredBy;

    private final Boolean enabled;

    private final String event;

    private final Integer threshold;

    private NotificationSettingDetail(BuilderImpl builder) {
        this.channel = builder.channel;
        this.configuredBy = builder.configuredBy;
        this.enabled = builder.enabled;
        this.event = builder.event;
        this.threshold = builder.threshold;
    }

    /**
     * <p>
     * The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health
     * Dashboard to notify for an event.
     * </p>
     * <note>
     * <p>
     * In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link NotificationChannel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelAsString}.
     * </p>
     * 
     * @return The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and
     *         Health Dashboard to notify for an event.</p> <note>
     *         <p>
     *         In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
     *         </p>
     * @see NotificationChannel
     */
    public final NotificationChannel channel() {
        return NotificationChannel.fromValue(channel);
    }

    /**
     * <p>
     * The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health
     * Dashboard to notify for an event.
     * </p>
     * <note>
     * <p>
     * In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link NotificationChannel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelAsString}.
     * </p>
     * 
     * @return The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and
     *         Health Dashboard to notify for an event.</p> <note>
     *         <p>
     *         In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
     *         </p>
     * @see NotificationChannel
     */
    public final String channelAsString() {
        return channel;
    }

    /**
     * <p>
     * The principal that configured the notification setting. For default settings configured by IAM Roles Anywhere,
     * the value is <code>rolesanywhere.amazonaws.com</code>, and for customized notifications settings, it is the
     * respective account ID.
     * </p>
     * 
     * @return The principal that configured the notification setting. For default settings configured by IAM Roles
     *         Anywhere, the value is <code>rolesanywhere.amazonaws.com</code>, and for customized notifications
     *         settings, it is the respective account ID.
     */
    public final String configuredBy() {
        return configuredBy;
    }

    /**
     * <p>
     * Indicates whether the notification setting is enabled.
     * </p>
     * 
     * @return Indicates whether the notification setting is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The event to which this notification setting is applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link NotificationEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The event to which this notification setting is applied.
     * @see NotificationEvent
     */
    public final NotificationEvent event() {
        return NotificationEvent.fromValue(event);
    }

    /**
     * <p>
     * The event to which this notification setting is applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link NotificationEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The event to which this notification setting is applied.
     * @see NotificationEvent
     */
    public final String eventAsString() {
        return event;
    }

    /**
     * <p>
     * The number of days before a notification event.
     * </p>
     * 
     * @return The number of days before a notification event.
     */
    public final Integer threshold() {
        return threshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuredBy());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationSettingDetail)) {
            return false;
        }
        NotificationSettingDetail other = (NotificationSettingDetail) obj;
        return Objects.equals(channelAsString(), other.channelAsString()) && Objects.equals(configuredBy(), other.configuredBy())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(eventAsString(), other.eventAsString())
                && Objects.equals(threshold(), other.threshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationSettingDetail").add("Channel", channelAsString())
                .add("ConfiguredBy", configuredBy()).add("Enabled", enabled()).add("Event", eventAsString())
                .add("Threshold", threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        case "configuredBy":
            return Optional.ofNullable(clazz.cast(configuredBy()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        case "threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channel", CHANNEL_FIELD);
        map.put("configuredBy", CONFIGURED_BY_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("event", EVENT_FIELD);
        map.put("threshold", THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationSettingDetail, T> g) {
        return obj -> g.apply((NotificationSettingDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationSettingDetail> {
        /**
         * <p>
         * The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health
         * Dashboard to notify for an event.
         * </p>
         * <note>
         * <p>
         * In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
         * </p>
         * </note>
         * 
         * @param channel
         *        The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and
         *        Health Dashboard to notify for an event.</p> <note>
         *        <p>
         *        In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
         *        </p>
         * @see NotificationChannel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationChannel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health
         * Dashboard to notify for an event.
         * </p>
         * <note>
         * <p>
         * In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
         * </p>
         * </note>
         * 
         * @param channel
         *        The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and
         *        Health Dashboard to notify for an event.</p> <note>
         *        <p>
         *        In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
         *        </p>
         * @see NotificationChannel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationChannel
         */
        Builder channel(NotificationChannel channel);

        /**
         * <p>
         * The principal that configured the notification setting. For default settings configured by IAM Roles
         * Anywhere, the value is <code>rolesanywhere.amazonaws.com</code>, and for customized notifications settings,
         * it is the respective account ID.
         * </p>
         * 
         * @param configuredBy
         *        The principal that configured the notification setting. For default settings configured by IAM Roles
         *        Anywhere, the value is <code>rolesanywhere.amazonaws.com</code>, and for customized notifications
         *        settings, it is the respective account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredBy(String configuredBy);

        /**
         * <p>
         * Indicates whether the notification setting is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the notification setting is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The event to which this notification setting is applied.
         * </p>
         * 
         * @param event
         *        The event to which this notification setting is applied.
         * @see NotificationEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationEvent
         */
        Builder event(String event);

        /**
         * <p>
         * The event to which this notification setting is applied.
         * </p>
         * 
         * @param event
         *        The event to which this notification setting is applied.
         * @see NotificationEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationEvent
         */
        Builder event(NotificationEvent event);

        /**
         * <p>
         * The number of days before a notification event.
         * </p>
         * 
         * @param threshold
         *        The number of days before a notification event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Integer threshold);
    }

    static final class BuilderImpl implements Builder {
        private String channel;

        private String configuredBy;

        private Boolean enabled;

        private String event;

        private Integer threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationSettingDetail model) {
            channel(model.channel);
            configuredBy(model.configuredBy);
            enabled(model.enabled);
            event(model.event);
            threshold(model.threshold);
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(NotificationChannel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final String getConfiguredBy() {
            return configuredBy;
        }

        public final void setConfiguredBy(String configuredBy) {
            this.configuredBy = configuredBy;
        }

        @Override
        public final Builder configuredBy(String configuredBy) {
            this.configuredBy = configuredBy;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getEvent() {
            return event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(NotificationEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final Integer getThreshold() {
            return threshold;
        }

        public final void setThreshold(Integer threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Integer threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public NotificationSettingDetail build() {
            return new NotificationSettingDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
