/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of the subject after a read or write operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubjectDetail implements SdkPojo, Serializable, ToCopyableBuilder<SubjectDetail.Builder, SubjectDetail> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(SubjectDetail::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<CredentialSummary>> CREDENTIALS_FIELD = SdkField
            .<List<CredentialSummary>> builder(MarshallingType.LIST)
            .memberName("credentials")
            .getter(getter(SubjectDetail::credentials))
            .setter(setter(Builder::credentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CredentialSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CredentialSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(SubjectDetail::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<List<InstanceProperty>> INSTANCE_PROPERTIES_FIELD = SdkField
            .<List<InstanceProperty>> builder(MarshallingType.LIST)
            .memberName("instanceProperties")
            .getter(getter(SubjectDetail::instanceProperties))
            .setter(setter(Builder::instanceProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_SEEN_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastSeenAt")
            .getter(getter(SubjectDetail::lastSeenAt))
            .setter(setter(Builder::lastSeenAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeenAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SUBJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectArn").getter(getter(SubjectDetail::subjectArn)).setter(setter(Builder::subjectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectArn").build()).build();

    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectId").getter(getter(SubjectDetail::subjectId)).setter(setter(Builder::subjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(SubjectDetail::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> X509_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("x509Subject").getter(getter(SubjectDetail::x509Subject)).setter(setter(Builder::x509Subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x509Subject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREDENTIALS_FIELD, ENABLED_FIELD, INSTANCE_PROPERTIES_FIELD, LAST_SEEN_AT_FIELD, SUBJECT_ARN_FIELD, SUBJECT_ID_FIELD,
            UPDATED_AT_FIELD, X509_SUBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final List<CredentialSummary> credentials;

    private final Boolean enabled;

    private final List<InstanceProperty> instanceProperties;

    private final Instant lastSeenAt;

    private final String subjectArn;

    private final String subjectId;

    private final Instant updatedAt;

    private final String x509Subject;

    private SubjectDetail(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.credentials = builder.credentials;
        this.enabled = builder.enabled;
        this.instanceProperties = builder.instanceProperties;
        this.lastSeenAt = builder.lastSeenAt;
        this.subjectArn = builder.subjectArn;
        this.subjectId = builder.subjectId;
        this.updatedAt = builder.updatedAt;
        this.x509Subject = builder.x509Subject;
    }

    /**
     * <p>
     * The ISO-8601 timestamp when the subject was created.
     * </p>
     * 
     * @return The ISO-8601 timestamp when the subject was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Credentials property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCredentials() {
        return credentials != null && !(credentials instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The temporary session credentials vended at the last authenticating call with this subject.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCredentials} method.
     * </p>
     * 
     * @return The temporary session credentials vended at the last authenticating call with this subject.
     */
    public final List<CredentialSummary> credentials() {
        return credentials;
    }

    /**
     * <p>
     * The enabled status of the subject.
     * </p>
     * 
     * @return The enabled status of the subject.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceProperties() {
        return instanceProperties != null && !(instanceProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specified instance properties associated with the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceProperties} method.
     * </p>
     * 
     * @return The specified instance properties associated with the request.
     */
    public final List<InstanceProperty> instanceProperties() {
        return instanceProperties;
    }

    /**
     * <p>
     * The ISO-8601 timestamp of the last time this subject requested temporary session credentials.
     * </p>
     * 
     * @return The ISO-8601 timestamp of the last time this subject requested temporary session credentials.
     */
    public final Instant lastSeenAt() {
        return lastSeenAt;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String subjectArn() {
        return subjectArn;
    }

    /**
     * <p>
     * The id of the resource
     * </p>
     * 
     * @return The id of the resource
     */
    public final String subjectId() {
        return subjectId;
    }

    /**
     * <p>
     * The ISO-8601 timestamp when the subject was last updated.
     * </p>
     * 
     * @return The ISO-8601 timestamp when the subject was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The x509 principal identifier of the authenticating certificate.
     * </p>
     * 
     * @return The x509 principal identifier of the authenticating certificate.
     */
    public final String x509Subject() {
        return x509Subject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasCredentials() ? credentials() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceProperties() ? instanceProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastSeenAt());
        hashCode = 31 * hashCode + Objects.hashCode(subjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(x509Subject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubjectDetail)) {
            return false;
        }
        SubjectDetail other = (SubjectDetail) obj;
        return Objects.equals(createdAt(), other.createdAt()) && hasCredentials() == other.hasCredentials()
                && Objects.equals(credentials(), other.credentials()) && Objects.equals(enabled(), other.enabled())
                && hasInstanceProperties() == other.hasInstanceProperties()
                && Objects.equals(instanceProperties(), other.instanceProperties())
                && Objects.equals(lastSeenAt(), other.lastSeenAt()) && Objects.equals(subjectArn(), other.subjectArn())
                && Objects.equals(subjectId(), other.subjectId()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(x509Subject(), other.x509Subject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubjectDetail").add("CreatedAt", createdAt())
                .add("Credentials", hasCredentials() ? credentials() : null).add("Enabled", enabled())
                .add("InstanceProperties", hasInstanceProperties() ? instanceProperties() : null).add("LastSeenAt", lastSeenAt())
                .add("SubjectArn", subjectArn()).add("SubjectId", subjectId()).add("UpdatedAt", updatedAt())
                .add("X509Subject", x509Subject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "instanceProperties":
            return Optional.ofNullable(clazz.cast(instanceProperties()));
        case "lastSeenAt":
            return Optional.ofNullable(clazz.cast(lastSeenAt()));
        case "subjectArn":
            return Optional.ofNullable(clazz.cast(subjectArn()));
        case "subjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "x509Subject":
            return Optional.ofNullable(clazz.cast(x509Subject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("credentials", CREDENTIALS_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("instanceProperties", INSTANCE_PROPERTIES_FIELD);
        map.put("lastSeenAt", LAST_SEEN_AT_FIELD);
        map.put("subjectArn", SUBJECT_ARN_FIELD);
        map.put("subjectId", SUBJECT_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("x509Subject", X509_SUBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubjectDetail, T> g) {
        return obj -> g.apply((SubjectDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubjectDetail> {
        /**
         * <p>
         * The ISO-8601 timestamp when the subject was created.
         * </p>
         * 
         * @param createdAt
         *        The ISO-8601 timestamp when the subject was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The temporary session credentials vended at the last authenticating call with this subject.
         * </p>
         * 
         * @param credentials
         *        The temporary session credentials vended at the last authenticating call with this subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Collection<CredentialSummary> credentials);

        /**
         * <p>
         * The temporary session credentials vended at the last authenticating call with this subject.
         * </p>
         * 
         * @param credentials
         *        The temporary session credentials vended at the last authenticating call with this subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(CredentialSummary... credentials);

        /**
         * <p>
         * The temporary session credentials vended at the last authenticating call with this subject.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.CredentialSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.rolesanywhere.model.CredentialSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.CredentialSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #credentials(List<CredentialSummary>)}.
         * 
         * @param credentials
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.CredentialSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(java.util.Collection<CredentialSummary>)
         */
        Builder credentials(Consumer<CredentialSummary.Builder>... credentials);

        /**
         * <p>
         * The enabled status of the subject.
         * </p>
         * 
         * @param enabled
         *        The enabled status of the subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The specified instance properties associated with the request.
         * </p>
         * 
         * @param instanceProperties
         *        The specified instance properties associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProperties(Collection<InstanceProperty> instanceProperties);

        /**
         * <p>
         * The specified instance properties associated with the request.
         * </p>
         * 
         * @param instanceProperties
         *        The specified instance properties associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProperties(InstanceProperty... instanceProperties);

        /**
         * <p>
         * The specified instance properties associated with the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.InstanceProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.rolesanywhere.model.InstanceProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.InstanceProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceProperties(List<InstanceProperty>)}.
         * 
         * @param instanceProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.InstanceProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceProperties(java.util.Collection<InstanceProperty>)
         */
        Builder instanceProperties(Consumer<InstanceProperty.Builder>... instanceProperties);

        /**
         * <p>
         * The ISO-8601 timestamp of the last time this subject requested temporary session credentials.
         * </p>
         * 
         * @param lastSeenAt
         *        The ISO-8601 timestamp of the last time this subject requested temporary session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeenAt(Instant lastSeenAt);

        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param subjectArn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectArn(String subjectArn);

        /**
         * <p>
         * The id of the resource
         * </p>
         * 
         * @param subjectId
         *        The id of the resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        /**
         * <p>
         * The ISO-8601 timestamp when the subject was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The ISO-8601 timestamp when the subject was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The x509 principal identifier of the authenticating certificate.
         * </p>
         * 
         * @param x509Subject
         *        The x509 principal identifier of the authenticating certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x509Subject(String x509Subject);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private List<CredentialSummary> credentials = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private List<InstanceProperty> instanceProperties = DefaultSdkAutoConstructList.getInstance();

        private Instant lastSeenAt;

        private String subjectArn;

        private String subjectId;

        private Instant updatedAt;

        private String x509Subject;

        private BuilderImpl() {
        }

        private BuilderImpl(SubjectDetail model) {
            createdAt(model.createdAt);
            credentials(model.credentials);
            enabled(model.enabled);
            instanceProperties(model.instanceProperties);
            lastSeenAt(model.lastSeenAt);
            subjectArn(model.subjectArn);
            subjectId(model.subjectId);
            updatedAt(model.updatedAt);
            x509Subject(model.x509Subject);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final List<CredentialSummary.Builder> getCredentials() {
            List<CredentialSummary.Builder> result = CredentialSummariesCopier.copyToBuilder(this.credentials);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentials(Collection<CredentialSummary.BuilderImpl> credentials) {
            this.credentials = CredentialSummariesCopier.copyFromBuilder(credentials);
        }

        @Override
        public final Builder credentials(Collection<CredentialSummary> credentials) {
            this.credentials = CredentialSummariesCopier.copy(credentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(CredentialSummary... credentials) {
            credentials(Arrays.asList(credentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Consumer<CredentialSummary.Builder>... credentials) {
            credentials(Stream.of(credentials).map(c -> CredentialSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<InstanceProperty.Builder> getInstanceProperties() {
            List<InstanceProperty.Builder> result = InstancePropertiesCopier.copyToBuilder(this.instanceProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceProperties(Collection<InstanceProperty.BuilderImpl> instanceProperties) {
            this.instanceProperties = InstancePropertiesCopier.copyFromBuilder(instanceProperties);
        }

        @Override
        public final Builder instanceProperties(Collection<InstanceProperty> instanceProperties) {
            this.instanceProperties = InstancePropertiesCopier.copy(instanceProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProperties(InstanceProperty... instanceProperties) {
            instanceProperties(Arrays.asList(instanceProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProperties(Consumer<InstanceProperty.Builder>... instanceProperties) {
            instanceProperties(Stream.of(instanceProperties).map(c -> InstanceProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastSeenAt() {
            return lastSeenAt;
        }

        public final void setLastSeenAt(Instant lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
        }

        @Override
        public final Builder lastSeenAt(Instant lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        public final String getSubjectArn() {
            return subjectArn;
        }

        public final void setSubjectArn(String subjectArn) {
            this.subjectArn = subjectArn;
        }

        @Override
        public final Builder subjectArn(String subjectArn) {
            this.subjectArn = subjectArn;
            return this;
        }

        public final String getSubjectId() {
            return subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getX509Subject() {
            return x509Subject;
        }

        public final void setX509Subject(String x509Subject) {
            this.x509Subject = x509Subject;
        }

        @Override
        public final Builder x509Subject(String x509Subject) {
            this.x509Subject = x509Subject;
            return this;
        }

        @Override
        public SubjectDetail build() {
            return new SubjectDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
