/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary representation of subjects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubjectSummary implements SdkPojo, Serializable, ToCopyableBuilder<SubjectSummary.Builder, SubjectSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(SubjectSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(SubjectSummary::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Instant> LAST_SEEN_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastSeenAt")
            .getter(getter(SubjectSummary::lastSeenAt))
            .setter(setter(Builder::lastSeenAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeenAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SUBJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectArn").getter(getter(SubjectSummary::subjectArn)).setter(setter(Builder::subjectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectArn").build()).build();

    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectId").getter(getter(SubjectSummary::subjectId)).setter(setter(Builder::subjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(SubjectSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> X509_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("x509Subject").getter(getter(SubjectSummary::x509Subject)).setter(setter(Builder::x509Subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x509Subject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            ENABLED_FIELD, LAST_SEEN_AT_FIELD, SUBJECT_ARN_FIELD, SUBJECT_ID_FIELD, UPDATED_AT_FIELD, X509_SUBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Boolean enabled;

    private final Instant lastSeenAt;

    private final String subjectArn;

    private final String subjectId;

    private final Instant updatedAt;

    private final String x509Subject;

    private SubjectSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.enabled = builder.enabled;
        this.lastSeenAt = builder.lastSeenAt;
        this.subjectArn = builder.subjectArn;
        this.subjectId = builder.subjectId;
        this.updatedAt = builder.updatedAt;
        this.x509Subject = builder.x509Subject;
    }

    /**
     * <p>
     * The ISO-8601 time stamp of when the certificate was first used in a temporary credential request.
     * </p>
     * 
     * @return The ISO-8601 time stamp of when the certificate was first used in a temporary credential request.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The enabled status of the subject.
     * </p>
     * 
     * @return The enabled status of the subject.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
     * </p>
     * 
     * @return The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
     */
    public final Instant lastSeenAt() {
        return lastSeenAt;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String subjectArn() {
        return subjectArn;
    }

    /**
     * <p>
     * The id of the resource.
     * </p>
     * 
     * @return The id of the resource.
     */
    public final String subjectId() {
        return subjectId;
    }

    /**
     * <p>
     * The ISO-8601 timestamp when the subject was last updated.
     * </p>
     * 
     * @return The ISO-8601 timestamp when the subject was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The x509 principal identifier of the authenticating certificate.
     * </p>
     * 
     * @return The x509 principal identifier of the authenticating certificate.
     */
    public final String x509Subject() {
        return x509Subject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(lastSeenAt());
        hashCode = 31 * hashCode + Objects.hashCode(subjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(x509Subject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubjectSummary)) {
            return false;
        }
        SubjectSummary other = (SubjectSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(lastSeenAt(), other.lastSeenAt()) && Objects.equals(subjectArn(), other.subjectArn())
                && Objects.equals(subjectId(), other.subjectId()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(x509Subject(), other.x509Subject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubjectSummary").add("CreatedAt", createdAt()).add("Enabled", enabled())
                .add("LastSeenAt", lastSeenAt()).add("SubjectArn", subjectArn()).add("SubjectId", subjectId())
                .add("UpdatedAt", updatedAt()).add("X509Subject", x509Subject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "lastSeenAt":
            return Optional.ofNullable(clazz.cast(lastSeenAt()));
        case "subjectArn":
            return Optional.ofNullable(clazz.cast(subjectArn()));
        case "subjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "x509Subject":
            return Optional.ofNullable(clazz.cast(x509Subject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("lastSeenAt", LAST_SEEN_AT_FIELD);
        map.put("subjectArn", SUBJECT_ARN_FIELD);
        map.put("subjectId", SUBJECT_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("x509Subject", X509_SUBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubjectSummary, T> g) {
        return obj -> g.apply((SubjectSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubjectSummary> {
        /**
         * <p>
         * The ISO-8601 time stamp of when the certificate was first used in a temporary credential request.
         * </p>
         * 
         * @param createdAt
         *        The ISO-8601 time stamp of when the certificate was first used in a temporary credential request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The enabled status of the subject.
         * </p>
         * 
         * @param enabled
         *        The enabled status of the subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
         * </p>
         * 
         * @param lastSeenAt
         *        The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeenAt(Instant lastSeenAt);

        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param subjectArn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectArn(String subjectArn);

        /**
         * <p>
         * The id of the resource.
         * </p>
         * 
         * @param subjectId
         *        The id of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        /**
         * <p>
         * The ISO-8601 timestamp when the subject was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The ISO-8601 timestamp when the subject was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The x509 principal identifier of the authenticating certificate.
         * </p>
         * 
         * @param x509Subject
         *        The x509 principal identifier of the authenticating certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x509Subject(String x509Subject);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Boolean enabled;

        private Instant lastSeenAt;

        private String subjectArn;

        private String subjectId;

        private Instant updatedAt;

        private String x509Subject;

        private BuilderImpl() {
        }

        private BuilderImpl(SubjectSummary model) {
            createdAt(model.createdAt);
            enabled(model.enabled);
            lastSeenAt(model.lastSeenAt);
            subjectArn(model.subjectArn);
            subjectId(model.subjectId);
            updatedAt(model.updatedAt);
            x509Subject(model.x509Subject);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Instant getLastSeenAt() {
            return lastSeenAt;
        }

        public final void setLastSeenAt(Instant lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
        }

        @Override
        public final Builder lastSeenAt(Instant lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        public final String getSubjectArn() {
            return subjectArn;
        }

        public final void setSubjectArn(String subjectArn) {
            this.subjectArn = subjectArn;
        }

        @Override
        public final Builder subjectArn(String subjectArn) {
            this.subjectArn = subjectArn;
            return this;
        }

        public final String getSubjectId() {
            return subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getX509Subject() {
            return x509Subject;
        }

        public final void setX509Subject(String x509Subject) {
            this.x509Subject = x509Subject;
        }

        @Override
        public final Builder x509Subject(String x509Subject) {
            this.x509Subject = x509Subject;
            return this;
        }

        @Override
        public SubjectSummary build() {
            return new SubjectSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
