/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of the certificate revocation list (CRL) after a read or write operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrlDetail implements SdkPojo, Serializable, ToCopyableBuilder<CrlDetail.Builder, CrlDetail> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CrlDetail::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CRL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("crlArn")
            .getter(getter(CrlDetail::crlArn)).setter(setter(Builder::crlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crlArn").build()).build();

    private static final SdkField<SdkBytes> CRL_DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("crlData").getter(getter(CrlDetail::crlData)).setter(setter(Builder::crlData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crlData").build()).build();

    private static final SdkField<String> CRL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("crlId")
            .getter(getter(CrlDetail::crlId)).setter(setter(Builder::crlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crlId").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(CrlDetail::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CrlDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TRUST_ANCHOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustAnchorArn").getter(getter(CrlDetail::trustAnchorArn)).setter(setter(Builder::trustAnchorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorArn").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(CrlDetail::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CRL_ARN_FIELD, CRL_DATA_FIELD, CRL_ID_FIELD, ENABLED_FIELD, NAME_FIELD, TRUST_ANCHOR_ARN_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String crlArn;

    private final SdkBytes crlData;

    private final String crlId;

    private final Boolean enabled;

    private final String name;

    private final String trustAnchorArn;

    private final Instant updatedAt;

    private CrlDetail(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.crlArn = builder.crlArn;
        this.crlData = builder.crlData;
        this.crlId = builder.crlId;
        this.enabled = builder.enabled;
        this.name = builder.name;
        this.trustAnchorArn = builder.trustAnchorArn;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ISO-8601 timestamp when the certificate revocation list (CRL) was created.
     * </p>
     * 
     * @return The ISO-8601 timestamp when the certificate revocation list (CRL) was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ARN of the certificate revocation list (CRL).
     * </p>
     * 
     * @return The ARN of the certificate revocation list (CRL).
     */
    public final String crlArn() {
        return crlArn;
    }

    /**
     * <p>
     * The state of the certificate revocation list (CRL) after a read or write operation.
     * </p>
     * 
     * @return The state of the certificate revocation list (CRL) after a read or write operation.
     */
    public final SdkBytes crlData() {
        return crlData;
    }

    /**
     * <p>
     * The unique identifier of the certificate revocation list (CRL).
     * </p>
     * 
     * @return The unique identifier of the certificate revocation list (CRL).
     */
    public final String crlId() {
        return crlId;
    }

    /**
     * <p>
     * Indicates whether the certificate revocation list (CRL) is enabled.
     * </p>
     * 
     * @return Indicates whether the certificate revocation list (CRL) is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the certificate revocation list (CRL).
     * </p>
     * 
     * @return The name of the certificate revocation list (CRL).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
     * </p>
     * 
     * @return The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
     */
    public final String trustAnchorArn() {
        return trustAnchorArn;
    }

    /**
     * <p>
     * The ISO-8601 timestamp when the certificate revocation list (CRL) was last updated.
     * </p>
     * 
     * @return The ISO-8601 timestamp when the certificate revocation list (CRL) was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(crlArn());
        hashCode = 31 * hashCode + Objects.hashCode(crlData());
        hashCode = 31 * hashCode + Objects.hashCode(crlId());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trustAnchorArn());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrlDetail)) {
            return false;
        }
        CrlDetail other = (CrlDetail) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(crlArn(), other.crlArn())
                && Objects.equals(crlData(), other.crlData()) && Objects.equals(crlId(), other.crlId())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(name(), other.name())
                && Objects.equals(trustAnchorArn(), other.trustAnchorArn()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrlDetail").add("CreatedAt", createdAt()).add("CrlArn", crlArn()).add("CrlData", crlData())
                .add("CrlId", crlId()).add("Enabled", enabled()).add("Name", name()).add("TrustAnchorArn", trustAnchorArn())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "crlArn":
            return Optional.ofNullable(clazz.cast(crlArn()));
        case "crlData":
            return Optional.ofNullable(clazz.cast(crlData()));
        case "crlId":
            return Optional.ofNullable(clazz.cast(crlId()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "trustAnchorArn":
            return Optional.ofNullable(clazz.cast(trustAnchorArn()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("crlArn", CRL_ARN_FIELD);
        map.put("crlData", CRL_DATA_FIELD);
        map.put("crlId", CRL_ID_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("name", NAME_FIELD);
        map.put("trustAnchorArn", TRUST_ANCHOR_ARN_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrlDetail, T> g) {
        return obj -> g.apply((CrlDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrlDetail> {
        /**
         * <p>
         * The ISO-8601 timestamp when the certificate revocation list (CRL) was created.
         * </p>
         * 
         * @param createdAt
         *        The ISO-8601 timestamp when the certificate revocation list (CRL) was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ARN of the certificate revocation list (CRL).
         * </p>
         * 
         * @param crlArn
         *        The ARN of the certificate revocation list (CRL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crlArn(String crlArn);

        /**
         * <p>
         * The state of the certificate revocation list (CRL) after a read or write operation.
         * </p>
         * 
         * @param crlData
         *        The state of the certificate revocation list (CRL) after a read or write operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crlData(SdkBytes crlData);

        /**
         * <p>
         * The unique identifier of the certificate revocation list (CRL).
         * </p>
         * 
         * @param crlId
         *        The unique identifier of the certificate revocation list (CRL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crlId(String crlId);

        /**
         * <p>
         * Indicates whether the certificate revocation list (CRL) is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the certificate revocation list (CRL) is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the certificate revocation list (CRL).
         * </p>
         * 
         * @param name
         *        The name of the certificate revocation list (CRL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
         * </p>
         * 
         * @param trustAnchorArn
         *        The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustAnchorArn(String trustAnchorArn);

        /**
         * <p>
         * The ISO-8601 timestamp when the certificate revocation list (CRL) was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The ISO-8601 timestamp when the certificate revocation list (CRL) was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String crlArn;

        private SdkBytes crlData;

        private String crlId;

        private Boolean enabled;

        private String name;

        private String trustAnchorArn;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CrlDetail model) {
            createdAt(model.createdAt);
            crlArn(model.crlArn);
            crlData(model.crlData);
            crlId(model.crlId);
            enabled(model.enabled);
            name(model.name);
            trustAnchorArn(model.trustAnchorArn);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCrlArn() {
            return crlArn;
        }

        public final void setCrlArn(String crlArn) {
            this.crlArn = crlArn;
        }

        @Override
        public final Builder crlArn(String crlArn) {
            this.crlArn = crlArn;
            return this;
        }

        public final ByteBuffer getCrlData() {
            return crlData == null ? null : crlData.asByteBuffer();
        }

        public final void setCrlData(ByteBuffer crlData) {
            crlData(crlData == null ? null : SdkBytes.fromByteBuffer(crlData));
        }

        @Override
        public final Builder crlData(SdkBytes crlData) {
            this.crlData = crlData;
            return this;
        }

        public final String getCrlId() {
            return crlId;
        }

        public final void setCrlId(String crlId) {
            this.crlId = crlId;
        }

        @Override
        public final Builder crlId(String crlId) {
            this.crlId = crlId;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrustAnchorArn() {
            return trustAnchorArn;
        }

        public final void setTrustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
        }

        @Override
        public final Builder trustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public CrlDetail build() {
            return new CrlDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
