/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableProfileResponse extends RolesAnywhereResponse implements
        ToCopyableBuilder<DisableProfileResponse.Builder, DisableProfileResponse> {
    private static final SdkField<ProfileDetail> PROFILE_FIELD = SdkField.<ProfileDetail> builder(MarshallingType.SDK_POJO)
            .memberName("profile").getter(getter(DisableProfileResponse::profile)).setter(setter(Builder::profile))
            .constructor(ProfileDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProfileDetail profile;

    private DisableProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profile = builder.profile;
    }

    /**
     * <p>
     * The state of the profile after a read or write operation.
     * </p>
     * 
     * @return The state of the profile after a read or write operation.
     */
    public final ProfileDetail profile() {
        return profile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableProfileResponse)) {
            return false;
        }
        DisableProfileResponse other = (DisableProfileResponse) obj;
        return Objects.equals(profile(), other.profile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableProfileResponse").add("Profile", profile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profile":
            return Optional.ofNullable(clazz.cast(profile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("profile", PROFILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableProfileResponse, T> g) {
        return obj -> g.apply((DisableProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RolesAnywhereResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisableProfileResponse> {
        /**
         * <p>
         * The state of the profile after a read or write operation.
         * </p>
         * 
         * @param profile
         *        The state of the profile after a read or write operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profile(ProfileDetail profile);

        /**
         * <p>
         * The state of the profile after a read or write operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDetail.Builder} avoiding the need
         * to create one manually via {@link ProfileDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #profile(ProfileDetail)}.
         * 
         * @param profile
         *        a consumer that will call methods on {@link ProfileDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profile(ProfileDetail)
         */
        default Builder profile(Consumer<ProfileDetail.Builder> profile) {
            return profile(ProfileDetail.builder().applyMutation(profile).build());
        }
    }

    static final class BuilderImpl extends RolesAnywhereResponse.BuilderImpl implements Builder {
        private ProfileDetail profile;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableProfileResponse model) {
            super(model);
            profile(model.profile);
        }

        public final ProfileDetail.Builder getProfile() {
            return profile != null ? profile.toBuilder() : null;
        }

        public final void setProfile(ProfileDetail.BuilderImpl profile) {
            this.profile = profile != null ? profile.build() : null;
        }

        @Override
        public final Builder profile(ProfileDetail profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public DisableProfileResponse build() {
            return new DisableProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
