/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single mapping entry for each supported specifier or sub-field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MappingRule implements SdkPojo, Serializable, ToCopyableBuilder<MappingRule.Builder, MappingRule> {
    private static final SdkField<String> SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("specifier").getter(getter(MappingRule::specifier)).setter(setter(Builder::specifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String specifier;

    private MappingRule(BuilderImpl builder) {
        this.specifier = builder.specifier;
    }

    /**
     * <p>
     * Specifier within a certificate field, such as CN, OU, or UID from the Subject field.
     * </p>
     * 
     * @return Specifier within a certificate field, such as CN, OU, or UID from the Subject field.
     */
    public final String specifier() {
        return specifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(specifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingRule)) {
            return false;
        }
        MappingRule other = (MappingRule) obj;
        return Objects.equals(specifier(), other.specifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MappingRule").add("Specifier", specifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "specifier":
            return Optional.ofNullable(clazz.cast(specifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("specifier", SPECIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MappingRule, T> g) {
        return obj -> g.apply((MappingRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MappingRule> {
        /**
         * <p>
         * Specifier within a certificate field, such as CN, OU, or UID from the Subject field.
         * </p>
         * 
         * @param specifier
         *        Specifier within a certificate field, such as CN, OU, or UID from the Subject field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specifier(String specifier);
    }

    static final class BuilderImpl implements Builder {
        private String specifier;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingRule model) {
            specifier(model.specifier);
        }

        public final String getSpecifier() {
            return specifier;
        }

        public final void setSpecifier(String specifier) {
            this.specifier = specifier;
        }

        @Override
        public final Builder specifier(String specifier) {
            this.specifier = specifier;
            return this;
        }

        @Override
        public MappingRule build() {
            return new MappingRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
