/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProfileRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<CreateProfileRequest.Builder, CreateProfileRequest> {
    private static final SdkField<Boolean> ACCEPT_ROLE_SESSION_NAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("acceptRoleSessionName").getter(getter(CreateProfileRequest::acceptRoleSessionName))
            .setter(setter(Builder::acceptRoleSessionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptRoleSessionName").build())
            .build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("durationSeconds").getter(getter(CreateProfileRequest::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(CreateProfileRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<List<String>> MANAGED_POLICY_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("managedPolicyArns")
            .getter(getter(CreateProfileRequest::managedPolicyArns))
            .setter(setter(Builder::managedPolicyArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedPolicyArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> REQUIRE_INSTANCE_PROPERTIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("requireInstanceProperties")
            .getter(getter(CreateProfileRequest::requireInstanceProperties)).setter(setter(Builder::requireInstanceProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requireInstanceProperties").build())
            .build();

    private static final SdkField<List<String>> ROLE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("roleArns")
            .getter(getter(CreateProfileRequest::roleArns))
            .setter(setter(Builder::roleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SESSION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionPolicy").getter(getter(CreateProfileRequest::sessionPolicy))
            .setter(setter(Builder::sessionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionPolicy").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCEPT_ROLE_SESSION_NAME_FIELD, DURATION_SECONDS_FIELD, ENABLED_FIELD, MANAGED_POLICY_ARNS_FIELD, NAME_FIELD,
            REQUIRE_INSTANCE_PROPERTIES_FIELD, ROLE_ARNS_FIELD, SESSION_POLICY_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean acceptRoleSessionName;

    private final Integer durationSeconds;

    private final Boolean enabled;

    private final List<String> managedPolicyArns;

    private final String name;

    private final Boolean requireInstanceProperties;

    private final List<String> roleArns;

    private final String sessionPolicy;

    private final List<Tag> tags;

    private CreateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.acceptRoleSessionName = builder.acceptRoleSessionName;
        this.durationSeconds = builder.durationSeconds;
        this.enabled = builder.enabled;
        this.managedPolicyArns = builder.managedPolicyArns;
        this.name = builder.name;
        this.requireInstanceProperties = builder.requireInstanceProperties;
        this.roleArns = builder.roleArns;
        this.sessionPolicy = builder.sessionPolicy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Used to determine if a custom role session name will be accepted in a temporary credential request.
     * </p>
     * 
     * @return Used to determine if a custom role session name will be accepted in a temporary credential request.
     */
    public final Boolean acceptRoleSessionName() {
        return acceptRoleSessionName;
    }

    /**
     * <p>
     * Used to determine how long sessions vended using this profile are valid for. See the <code>Expiration</code>
     * section of the <a href=
     * "https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object"
     * >CreateSession API documentation</a> page for more details. In requests, if this value is not provided, the
     * default value will be 3600.
     * </p>
     * 
     * @return Used to determine how long sessions vended using this profile are valid for. See the
     *         <code>Expiration</code> section of the <a href=
     *         "https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object"
     *         >CreateSession API documentation</a> page for more details. In requests, if this value is not provided,
     *         the default value will be 3600.
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * Specifies whether the profile is enabled.
     * </p>
     * 
     * @return Specifies whether the profile is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedPolicyArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedPolicyArns() {
        return managedPolicyArns != null && !(managedPolicyArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of managed policy ARNs that apply to the vended session credentials.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedPolicyArns} method.
     * </p>
     * 
     * @return A list of managed policy ARNs that apply to the vended session credentials.
     */
    public final List<String> managedPolicyArns() {
        return managedPolicyArns;
    }

    /**
     * <p>
     * The name of the profile.
     * </p>
     * 
     * @return The name of the profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether instance properties are required in temporary credential requests with this profile.
     * </p>
     * 
     * @return Specifies whether instance properties are required in temporary credential requests with this profile.
     */
    public final Boolean requireInstanceProperties() {
        return requireInstanceProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoleArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoleArns() {
        return roleArns != null && !(roleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM roles that this profile can assume in a temporary credential request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoleArns} method.
     * </p>
     * 
     * @return A list of IAM roles that this profile can assume in a temporary credential request.
     */
    public final List<String> roleArns() {
        return roleArns;
    }

    /**
     * <p>
     * A session policy that applies to the trust boundary of the vended session credentials.
     * </p>
     * 
     * @return A session policy that applies to the trust boundary of the vended session credentials.
     */
    public final String sessionPolicy() {
        return sessionPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to attach to the profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to attach to the profile.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptRoleSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedPolicyArns() ? managedPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requireInstanceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoleArns() ? roleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileRequest)) {
            return false;
        }
        CreateProfileRequest other = (CreateProfileRequest) obj;
        return Objects.equals(acceptRoleSessionName(), other.acceptRoleSessionName())
                && Objects.equals(durationSeconds(), other.durationSeconds()) && Objects.equals(enabled(), other.enabled())
                && hasManagedPolicyArns() == other.hasManagedPolicyArns()
                && Objects.equals(managedPolicyArns(), other.managedPolicyArns()) && Objects.equals(name(), other.name())
                && Objects.equals(requireInstanceProperties(), other.requireInstanceProperties())
                && hasRoleArns() == other.hasRoleArns() && Objects.equals(roleArns(), other.roleArns())
                && Objects.equals(sessionPolicy(), other.sessionPolicy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProfileRequest").add("AcceptRoleSessionName", acceptRoleSessionName())
                .add("DurationSeconds", durationSeconds()).add("Enabled", enabled())
                .add("ManagedPolicyArns", hasManagedPolicyArns() ? managedPolicyArns() : null).add("Name", name())
                .add("RequireInstanceProperties", requireInstanceProperties()).add("RoleArns", hasRoleArns() ? roleArns() : null)
                .add("SessionPolicy", sessionPolicy()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceptRoleSessionName":
            return Optional.ofNullable(clazz.cast(acceptRoleSessionName()));
        case "durationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "managedPolicyArns":
            return Optional.ofNullable(clazz.cast(managedPolicyArns()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "requireInstanceProperties":
            return Optional.ofNullable(clazz.cast(requireInstanceProperties()));
        case "roleArns":
            return Optional.ofNullable(clazz.cast(roleArns()));
        case "sessionPolicy":
            return Optional.ofNullable(clazz.cast(sessionPolicy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("acceptRoleSessionName", ACCEPT_ROLE_SESSION_NAME_FIELD);
        map.put("durationSeconds", DURATION_SECONDS_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("managedPolicyArns", MANAGED_POLICY_ARNS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("requireInstanceProperties", REQUIRE_INSTANCE_PROPERTIES_FIELD);
        map.put("roleArns", ROLE_ARNS_FIELD);
        map.put("sessionPolicy", SESSION_POLICY_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProfileRequest, T> g) {
        return obj -> g.apply((CreateProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProfileRequest> {
        /**
         * <p>
         * Used to determine if a custom role session name will be accepted in a temporary credential request.
         * </p>
         * 
         * @param acceptRoleSessionName
         *        Used to determine if a custom role session name will be accepted in a temporary credential request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptRoleSessionName(Boolean acceptRoleSessionName);

        /**
         * <p>
         * Used to determine how long sessions vended using this profile are valid for. See the <code>Expiration</code>
         * section of the <a href=
         * "https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object"
         * >CreateSession API documentation</a> page for more details. In requests, if this value is not provided, the
         * default value will be 3600.
         * </p>
         * 
         * @param durationSeconds
         *        Used to determine how long sessions vended using this profile are valid for. See the
         *        <code>Expiration</code> section of the <a href=
         *        "https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object"
         *        >CreateSession API documentation</a> page for more details. In requests, if this value is not
         *        provided, the default value will be 3600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * Specifies whether the profile is enabled.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the profile is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A list of managed policy ARNs that apply to the vended session credentials.
         * </p>
         * 
         * @param managedPolicyArns
         *        A list of managed policy ARNs that apply to the vended session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedPolicyArns(Collection<String> managedPolicyArns);

        /**
         * <p>
         * A list of managed policy ARNs that apply to the vended session credentials.
         * </p>
         * 
         * @param managedPolicyArns
         *        A list of managed policy ARNs that apply to the vended session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedPolicyArns(String... managedPolicyArns);

        /**
         * <p>
         * The name of the profile.
         * </p>
         * 
         * @param name
         *        The name of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether instance properties are required in temporary credential requests with this profile.
         * </p>
         * 
         * @param requireInstanceProperties
         *        Specifies whether instance properties are required in temporary credential requests with this profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireInstanceProperties(Boolean requireInstanceProperties);

        /**
         * <p>
         * A list of IAM roles that this profile can assume in a temporary credential request.
         * </p>
         * 
         * @param roleArns
         *        A list of IAM roles that this profile can assume in a temporary credential request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(Collection<String> roleArns);

        /**
         * <p>
         * A list of IAM roles that this profile can assume in a temporary credential request.
         * </p>
         * 
         * @param roleArns
         *        A list of IAM roles that this profile can assume in a temporary credential request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(String... roleArns);

        /**
         * <p>
         * A session policy that applies to the trust boundary of the vended session credentials.
         * </p>
         * 
         * @param sessionPolicy
         *        A session policy that applies to the trust boundary of the vended session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionPolicy(String sessionPolicy);

        /**
         * <p>
         * The tags to attach to the profile.
         * </p>
         * 
         * @param tags
         *        The tags to attach to the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to attach to the profile.
         * </p>
         * 
         * @param tags
         *        The tags to attach to the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to attach to the profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rolesanywhere.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private Boolean acceptRoleSessionName;

        private Integer durationSeconds;

        private Boolean enabled;

        private List<String> managedPolicyArns = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private Boolean requireInstanceProperties;

        private List<String> roleArns = DefaultSdkAutoConstructList.getInstance();

        private String sessionPolicy;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileRequest model) {
            super(model);
            acceptRoleSessionName(model.acceptRoleSessionName);
            durationSeconds(model.durationSeconds);
            enabled(model.enabled);
            managedPolicyArns(model.managedPolicyArns);
            name(model.name);
            requireInstanceProperties(model.requireInstanceProperties);
            roleArns(model.roleArns);
            sessionPolicy(model.sessionPolicy);
            tags(model.tags);
        }

        public final Boolean getAcceptRoleSessionName() {
            return acceptRoleSessionName;
        }

        public final void setAcceptRoleSessionName(Boolean acceptRoleSessionName) {
            this.acceptRoleSessionName = acceptRoleSessionName;
        }

        @Override
        public final Builder acceptRoleSessionName(Boolean acceptRoleSessionName) {
            this.acceptRoleSessionName = acceptRoleSessionName;
            return this;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Collection<String> getManagedPolicyArns() {
            if (managedPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return managedPolicyArns;
        }

        public final void setManagedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
        }

        @Override
        public final Builder managedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedPolicyArns(String... managedPolicyArns) {
            managedPolicyArns(Arrays.asList(managedPolicyArns));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getRequireInstanceProperties() {
            return requireInstanceProperties;
        }

        public final void setRequireInstanceProperties(Boolean requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
        }

        @Override
        public final Builder requireInstanceProperties(Boolean requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
            return this;
        }

        public final Collection<String> getRoleArns() {
            if (roleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return roleArns;
        }

        public final void setRoleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
        }

        @Override
        public final Builder roleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleArns(String... roleArns) {
            roleArns(Arrays.asList(roleArns));
            return this;
        }

        public final String getSessionPolicy() {
            return sessionPolicy;
        }

        public final void setSessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
        }

        @Override
        public final Builder sessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfileRequest build() {
            return new CreateProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
