/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrustAnchorRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<CreateTrustAnchorRequest.Builder, CreateTrustAnchorRequest> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(CreateTrustAnchorRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateTrustAnchorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<NotificationSetting>> NOTIFICATION_SETTINGS_FIELD = SdkField
            .<List<NotificationSetting>> builder(MarshallingType.LIST)
            .memberName("notificationSettings")
            .getter(getter(CreateTrustAnchorRequest::notificationSettings))
            .setter(setter(Builder::notificationSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(CreateTrustAnchorRequest::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateTrustAnchorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, NAME_FIELD,
            NOTIFICATION_SETTINGS_FIELD, SOURCE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean enabled;

    private final String name;

    private final List<NotificationSetting> notificationSettings;

    private final Source source;

    private final List<Tag> tags;

    private CreateTrustAnchorRequest(BuilderImpl builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.name = builder.name;
        this.notificationSettings = builder.notificationSettings;
        this.source = builder.source;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies whether the trust anchor is enabled.
     * </p>
     * 
     * @return Specifies whether the trust anchor is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the trust anchor.
     * </p>
     * 
     * @return The name of the trust anchor.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationSettings() {
        return notificationSettings != null && !(notificationSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of notification settings to be associated to the trust anchor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationSettings} method.
     * </p>
     * 
     * @return A list of notification settings to be associated to the trust anchor.
     */
    public final List<NotificationSetting> notificationSettings() {
        return notificationSettings;
    }

    /**
     * <p>
     * The trust anchor type and its related certificate data.
     * </p>
     * 
     * @return The trust anchor type and its related certificate data.
     */
    public final Source source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to attach to the trust anchor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to attach to the trust anchor.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationSettings() ? notificationSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustAnchorRequest)) {
            return false;
        }
        CreateTrustAnchorRequest other = (CreateTrustAnchorRequest) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(name(), other.name())
                && hasNotificationSettings() == other.hasNotificationSettings()
                && Objects.equals(notificationSettings(), other.notificationSettings())
                && Objects.equals(source(), other.source()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrustAnchorRequest").add("Enabled", enabled()).add("Name", name())
                .add("NotificationSettings", hasNotificationSettings() ? notificationSettings() : null).add("Source", source())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "notificationSettings":
            return Optional.ofNullable(clazz.cast(notificationSettings()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("name", NAME_FIELD);
        map.put("notificationSettings", NOTIFICATION_SETTINGS_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustAnchorRequest, T> g) {
        return obj -> g.apply((CreateTrustAnchorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrustAnchorRequest> {
        /**
         * <p>
         * Specifies whether the trust anchor is enabled.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the trust anchor is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the trust anchor.
         * </p>
         * 
         * @param name
         *        The name of the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of notification settings to be associated to the trust anchor.
         * </p>
         * 
         * @param notificationSettings
         *        A list of notification settings to be associated to the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSettings(Collection<NotificationSetting> notificationSettings);

        /**
         * <p>
         * A list of notification settings to be associated to the trust anchor.
         * </p>
         * 
         * @param notificationSettings
         *        A list of notification settings to be associated to the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSettings(NotificationSetting... notificationSettings);

        /**
         * <p>
         * A list of notification settings to be associated to the trust anchor.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationSettings(List<NotificationSetting>)}.
         * 
         * @param notificationSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationSettings(java.util.Collection<NotificationSetting>)
         */
        Builder notificationSettings(Consumer<NotificationSetting.Builder>... notificationSettings);

        /**
         * <p>
         * The trust anchor type and its related certificate data.
         * </p>
         * 
         * @param source
         *        The trust anchor type and its related certificate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The trust anchor type and its related certificate data.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The tags to attach to the trust anchor.
         * </p>
         * 
         * @param tags
         *        The tags to attach to the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to attach to the trust anchor.
         * </p>
         * 
         * @param tags
         *        The tags to attach to the trust anchor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to attach to the trust anchor.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rolesanywhere.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private Boolean enabled;

        private String name;

        private List<NotificationSetting> notificationSettings = DefaultSdkAutoConstructList.getInstance();

        private Source source;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustAnchorRequest model) {
            super(model);
            enabled(model.enabled);
            name(model.name);
            notificationSettings(model.notificationSettings);
            source(model.source);
            tags(model.tags);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<NotificationSetting.Builder> getNotificationSettings() {
            List<NotificationSetting.Builder> result = NotificationSettingsCopier.copyToBuilder(this.notificationSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationSettings(Collection<NotificationSetting.BuilderImpl> notificationSettings) {
            this.notificationSettings = NotificationSettingsCopier.copyFromBuilder(notificationSettings);
        }

        @Override
        public final Builder notificationSettings(Collection<NotificationSetting> notificationSettings) {
            this.notificationSettings = NotificationSettingsCopier.copy(notificationSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(NotificationSetting... notificationSettings) {
            notificationSettings(Arrays.asList(notificationSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(Consumer<NotificationSetting.Builder>... notificationSettings) {
            notificationSettings(Stream.of(notificationSettings).map(c -> NotificationSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrustAnchorRequest build() {
            return new CreateTrustAnchorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
