/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAttributeMappingRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<PutAttributeMappingRequest.Builder, PutAttributeMappingRequest> {
    private static final SdkField<String> CERTIFICATE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateField").getter(getter(PutAttributeMappingRequest::certificateFieldAsString))
            .setter(setter(Builder::certificateField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateField").build()).build();

    private static final SdkField<List<MappingRule>> MAPPING_RULES_FIELD = SdkField
            .<List<MappingRule>> builder(MarshallingType.LIST)
            .memberName("mappingRules")
            .getter(getter(PutAttributeMappingRequest::mappingRules))
            .setter(setter(Builder::mappingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MappingRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(MappingRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(PutAttributeMappingRequest::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD_FIELD,
            MAPPING_RULES_FIELD, PROFILE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String certificateField;

    private final List<MappingRule> mappingRules;

    private final String profileId;

    private PutAttributeMappingRequest(BuilderImpl builder) {
        super(builder);
        this.certificateField = builder.certificateField;
        this.mappingRules = builder.mappingRules;
        this.profileId = builder.profileId;
    }

    /**
     * <p>
     * Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateField}
     * will return {@link CertificateField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #certificateFieldAsString}.
     * </p>
     * 
     * @return Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
     * @see CertificateField
     */
    public final CertificateField certificateField() {
        return CertificateField.fromValue(certificateField);
    }

    /**
     * <p>
     * Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateField}
     * will return {@link CertificateField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #certificateFieldAsString}.
     * </p>
     * 
     * @return Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
     * @see CertificateField
     */
    public final String certificateFieldAsString() {
        return certificateField;
    }

    /**
     * For responses, this returns true if the service returned a value for the MappingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMappingRules() {
        return mappingRules != null && !(mappingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of mapping entries for every supported specifier or sub-field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMappingRules} method.
     * </p>
     * 
     * @return A list of mapping entries for every supported specifier or sub-field.
     */
    public final List<MappingRule> mappingRules() {
        return mappingRules;
    }

    /**
     * <p>
     * The unique identifier of the profile.
     * </p>
     * 
     * @return The unique identifier of the profile.
     */
    public final String profileId() {
        return profileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateFieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMappingRules() ? mappingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAttributeMappingRequest)) {
            return false;
        }
        PutAttributeMappingRequest other = (PutAttributeMappingRequest) obj;
        return Objects.equals(certificateFieldAsString(), other.certificateFieldAsString())
                && hasMappingRules() == other.hasMappingRules() && Objects.equals(mappingRules(), other.mappingRules())
                && Objects.equals(profileId(), other.profileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAttributeMappingRequest").add("CertificateField", certificateFieldAsString())
                .add("MappingRules", hasMappingRules() ? mappingRules() : null).add("ProfileId", profileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateField":
            return Optional.ofNullable(clazz.cast(certificateFieldAsString()));
        case "mappingRules":
            return Optional.ofNullable(clazz.cast(mappingRules()));
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateField", CERTIFICATE_FIELD_FIELD);
        map.put("mappingRules", MAPPING_RULES_FIELD);
        map.put("profileId", PROFILE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAttributeMappingRequest, T> g) {
        return obj -> g.apply((PutAttributeMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAttributeMappingRequest> {
        /**
         * <p>
         * Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
         * </p>
         * 
         * @param certificateField
         *        Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
         * @see CertificateField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateField
         */
        Builder certificateField(String certificateField);

        /**
         * <p>
         * Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
         * </p>
         * 
         * @param certificateField
         *        Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
         * @see CertificateField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateField
         */
        Builder certificateField(CertificateField certificateField);

        /**
         * <p>
         * A list of mapping entries for every supported specifier or sub-field.
         * </p>
         * 
         * @param mappingRules
         *        A list of mapping entries for every supported specifier or sub-field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingRules(Collection<MappingRule> mappingRules);

        /**
         * <p>
         * A list of mapping entries for every supported specifier or sub-field.
         * </p>
         * 
         * @param mappingRules
         *        A list of mapping entries for every supported specifier or sub-field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingRules(MappingRule... mappingRules);

        /**
         * <p>
         * A list of mapping entries for every supported specifier or sub-field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.MappingRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rolesanywhere.model.MappingRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.MappingRule.Builder#build()} is called immediately
         * and its result is passed to {@link #mappingRules(List<MappingRule>)}.
         * 
         * @param mappingRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.MappingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mappingRules(java.util.Collection<MappingRule>)
         */
        Builder mappingRules(Consumer<MappingRule.Builder>... mappingRules);

        /**
         * <p>
         * The unique identifier of the profile.
         * </p>
         * 
         * @param profileId
         *        The unique identifier of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private String certificateField;

        private List<MappingRule> mappingRules = DefaultSdkAutoConstructList.getInstance();

        private String profileId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAttributeMappingRequest model) {
            super(model);
            certificateField(model.certificateField);
            mappingRules(model.mappingRules);
            profileId(model.profileId);
        }

        public final String getCertificateField() {
            return certificateField;
        }

        public final void setCertificateField(String certificateField) {
            this.certificateField = certificateField;
        }

        @Override
        public final Builder certificateField(String certificateField) {
            this.certificateField = certificateField;
            return this;
        }

        @Override
        public final Builder certificateField(CertificateField certificateField) {
            this.certificateField(certificateField == null ? null : certificateField.toString());
            return this;
        }

        public final List<MappingRule.Builder> getMappingRules() {
            List<MappingRule.Builder> result = MappingRulesCopier.copyToBuilder(this.mappingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappingRules(Collection<MappingRule.BuilderImpl> mappingRules) {
            this.mappingRules = MappingRulesCopier.copyFromBuilder(mappingRules);
        }

        @Override
        public final Builder mappingRules(Collection<MappingRule> mappingRules) {
            this.mappingRules = MappingRulesCopier.copy(mappingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappingRules(MappingRule... mappingRules) {
            mappingRules(Arrays.asList(mappingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappingRules(Consumer<MappingRule.Builder>... mappingRules) {
            mappingRules(Stream.of(mappingRules).map(c -> MappingRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAttributeMappingRequest build() {
            return new PutAttributeMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
