/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCrlRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<UpdateCrlRequest.Builder, UpdateCrlRequest> {
    private static final SdkField<SdkBytes> CRL_DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("crlData").getter(getter(UpdateCrlRequest::crlData)).setter(setter(Builder::crlData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crlData").build()).build();

    private static final SdkField<String> CRL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("crlId")
            .getter(getter(UpdateCrlRequest::crlId)).setter(setter(Builder::crlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("crlId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateCrlRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRL_DATA_FIELD, CRL_ID_FIELD,
            NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SdkBytes crlData;

    private final String crlId;

    private final String name;

    private UpdateCrlRequest(BuilderImpl builder) {
        super(builder);
        this.crlData = builder.crlData;
        this.crlId = builder.crlId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The x509 v3 specified certificate revocation list (CRL).
     * </p>
     * 
     * @return The x509 v3 specified certificate revocation list (CRL).
     */
    public final SdkBytes crlData() {
        return crlData;
    }

    /**
     * <p>
     * The unique identifier of the certificate revocation list (CRL).
     * </p>
     * 
     * @return The unique identifier of the certificate revocation list (CRL).
     */
    public final String crlId() {
        return crlId;
    }

    /**
     * <p>
     * The name of the Crl.
     * </p>
     * 
     * @return The name of the Crl.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crlData());
        hashCode = 31 * hashCode + Objects.hashCode(crlId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCrlRequest)) {
            return false;
        }
        UpdateCrlRequest other = (UpdateCrlRequest) obj;
        return Objects.equals(crlData(), other.crlData()) && Objects.equals(crlId(), other.crlId())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCrlRequest").add("CrlData", crlData()).add("CrlId", crlId()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crlData":
            return Optional.ofNullable(clazz.cast(crlData()));
        case "crlId":
            return Optional.ofNullable(clazz.cast(crlId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("crlData", CRL_DATA_FIELD);
        map.put("crlId", CRL_ID_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCrlRequest, T> g) {
        return obj -> g.apply((UpdateCrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCrlRequest> {
        /**
         * <p>
         * The x509 v3 specified certificate revocation list (CRL).
         * </p>
         * 
         * @param crlData
         *        The x509 v3 specified certificate revocation list (CRL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crlData(SdkBytes crlData);

        /**
         * <p>
         * The unique identifier of the certificate revocation list (CRL).
         * </p>
         * 
         * @param crlId
         *        The unique identifier of the certificate revocation list (CRL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crlId(String crlId);

        /**
         * <p>
         * The name of the Crl.
         * </p>
         * 
         * @param name
         *        The name of the Crl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private SdkBytes crlData;

        private String crlId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCrlRequest model) {
            super(model);
            crlData(model.crlData);
            crlId(model.crlId);
            name(model.name);
        }

        public final ByteBuffer getCrlData() {
            return crlData == null ? null : crlData.asByteBuffer();
        }

        public final void setCrlData(ByteBuffer crlData) {
            crlData(crlData == null ? null : SdkBytes.fromByteBuffer(crlData));
        }

        @Override
        public final Builder crlData(SdkBytes crlData) {
            this.crlData = crlData;
            return this;
        }

        public final String getCrlId() {
            return crlId;
        }

        public final void setCrlId(String crlId) {
            this.crlId = crlId;
        }

        @Override
        public final Builder crlId(String crlId) {
            this.crlId = crlId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCrlRequest build() {
            return new UpdateCrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
