/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the <code>CreateTrafficPolicyVersion</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTrafficPolicyVersionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateTrafficPolicyVersionResponse.Builder, CreateTrafficPolicyVersionResponse> {
    private final TrafficPolicy trafficPolicy;

    private final String location;

    private CreateTrafficPolicyVersionResponse(BuilderImpl builder) {
        this.trafficPolicy = builder.trafficPolicy;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains settings for the new version of the traffic policy.
     * </p>
     * 
     * @return A complex type that contains settings for the new version of the traffic policy.
     */
    public TrafficPolicy trafficPolicy() {
        return trafficPolicy;
    }

    /**
     * <p>
     * A unique URL that represents a new traffic policy version.
     * </p>
     * 
     * @return A unique URL that represents a new traffic policy version.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((trafficPolicy() == null) ? 0 : trafficPolicy().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyVersionResponse)) {
            return false;
        }
        CreateTrafficPolicyVersionResponse other = (CreateTrafficPolicyVersionResponse) obj;
        if (other.trafficPolicy() == null ^ this.trafficPolicy() == null) {
            return false;
        }
        if (other.trafficPolicy() != null && !other.trafficPolicy().equals(this.trafficPolicy())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (trafficPolicy() != null) {
            sb.append("TrafficPolicy: ").append(trafficPolicy()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateTrafficPolicyVersionResponse> {
        /**
         * <p>
         * A complex type that contains settings for the new version of the traffic policy.
         * </p>
         * 
         * @param trafficPolicy
         *        A complex type that contains settings for the new version of the traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicy(TrafficPolicy trafficPolicy);

        /**
         * <p>
         * A unique URL that represents a new traffic policy version.
         * </p>
         * 
         * @param location
         *        A unique URL that represents a new traffic policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    private static final class BuilderImpl implements Builder {
        private TrafficPolicy trafficPolicy;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyVersionResponse model) {
            setTrafficPolicy(model.trafficPolicy);
            setLocation(model.location);
        }

        public final TrafficPolicy getTrafficPolicy() {
            return trafficPolicy;
        }

        @Override
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        public final void setTrafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateTrafficPolicyVersionResponse build() {
            return new CreateTrafficPolicyVersionResponse(this);
        }
    }
}
