/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to delete a specified traffic policy instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteTrafficPolicyInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteTrafficPolicyInstanceRequest.Builder, DeleteTrafficPolicyInstanceRequest> {
    private final String id;

    private DeleteTrafficPolicyInstanceRequest(BuilderImpl builder) {
        this.id = builder.id;
    }

    /**
     * <p>
     * The ID of the traffic policy instance that you want to delete.
     * </p>
     * <important>
     * <p>
     * When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were
     * created when you created the traffic policy instance.
     * </p>
     * </important>
     * 
     * @return The ID of the traffic policy instance that you want to delete. </p> <important>
     *         <p>
     *         When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets
     *         that were created when you created the traffic policy instance.
     *         </p>
     */
    public String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrafficPolicyInstanceRequest)) {
            return false;
        }
        DeleteTrafficPolicyInstanceRequest other = (DeleteTrafficPolicyInstanceRequest) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteTrafficPolicyInstanceRequest> {
        /**
         * <p>
         * The ID of the traffic policy instance that you want to delete.
         * </p>
         * <important>
         * <p>
         * When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that
         * were created when you created the traffic policy instance.
         * </p>
         * </important>
         * 
         * @param id
         *        The ID of the traffic policy instance that you want to delete. </p> <important>
         *        <p>
         *        When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record
         *        sets that were created when you created the traffic policy instance.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrafficPolicyInstanceRequest model) {
            setId(model.id);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public DeleteTrafficPolicyInstanceRequest build() {
            return new DeleteTrafficPolicyInstanceRequest(this);
        }
    }
}
