/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the disassociate request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DisassociateVPCFromHostedZoneResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DisassociateVPCFromHostedZoneResponse.Builder, DisassociateVPCFromHostedZoneResponse> {
    private final ChangeInfo changeInfo;

    private DisassociateVPCFromHostedZoneResponse(BuilderImpl builder) {
        this.changeInfo = builder.changeInfo;
    }

    /**
     * <p>
     * A complex type that describes the changes made to the specified private hosted zone.
     * </p>
     * 
     * @return A complex type that describes the changes made to the specified private hosted zone.
     */
    public ChangeInfo changeInfo() {
        return changeInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((changeInfo() == null) ? 0 : changeInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateVPCFromHostedZoneResponse)) {
            return false;
        }
        DisassociateVPCFromHostedZoneResponse other = (DisassociateVPCFromHostedZoneResponse) obj;
        if (other.changeInfo() == null ^ this.changeInfo() == null) {
            return false;
        }
        if (other.changeInfo() != null && !other.changeInfo().equals(this.changeInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (changeInfo() != null) {
            sb.append("ChangeInfo: ").append(changeInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DisassociateVPCFromHostedZoneResponse> {
        /**
         * <p>
         * A complex type that describes the changes made to the specified private hosted zone.
         * </p>
         * 
         * @param changeInfo
         *        A complex type that describes the changes made to the specified private hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeInfo(ChangeInfo changeInfo);
    }

    private static final class BuilderImpl implements Builder {
        private ChangeInfo changeInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateVPCFromHostedZoneResponse model) {
            setChangeInfo(model.changeInfo);
        }

        public final ChangeInfo getChangeInfo() {
            return changeInfo;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        public final void setChangeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
        }

        @Override
        public DisassociateVPCFromHostedZoneResponse build() {
            return new DisassociateVPCFromHostedZoneResponse(this);
        }
    }
}
