/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetCheckerIpRangesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetCheckerIpRangesResponse.Builder, GetCheckerIpRangesResponse> {
    private final List<String> checkerIpRanges;

    private GetCheckerIpRangesResponse(BuilderImpl builder) {
        this.checkerIpRanges = builder.checkerIpRanges;
    }

    /**
     *
     * @return
     */
    public List<String> checkerIpRanges() {
        return checkerIpRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((checkerIpRanges() == null) ? 0 : checkerIpRanges().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCheckerIpRangesResponse)) {
            return false;
        }
        GetCheckerIpRangesResponse other = (GetCheckerIpRangesResponse) obj;
        if (other.checkerIpRanges() == null ^ this.checkerIpRanges() == null) {
            return false;
        }
        if (other.checkerIpRanges() != null && !other.checkerIpRanges().equals(this.checkerIpRanges())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (checkerIpRanges() != null) {
            sb.append("CheckerIpRanges: ").append(checkerIpRanges()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetCheckerIpRangesResponse> {
        /**
         *
         * @param checkerIpRanges
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkerIpRanges(Collection<String> checkerIpRanges);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setCheckerIpRanges(java.util.Collection)} or {@link #withCheckerIpRanges(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param checkerIpRanges
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkerIpRanges(String... checkerIpRanges);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> checkerIpRanges = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCheckerIpRangesResponse model) {
            setCheckerIpRanges(model.checkerIpRanges);
        }

        public final Collection<String> getCheckerIpRanges() {
            return checkerIpRanges;
        }

        @Override
        public final Builder checkerIpRanges(Collection<String> checkerIpRanges) {
            this.checkerIpRanges = CheckerIpRangesCopier.copy(checkerIpRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkerIpRanges(String... checkerIpRanges) {
            if (this.checkerIpRanges == null) {
                this.checkerIpRanges = new SdkInternalList<>(checkerIpRanges.length);
            }
            for (String e : checkerIpRanges) {
                this.checkerIpRanges.add(e);
            }
            return this;
        }

        public final void setCheckerIpRanges(Collection<String> checkerIpRanges) {
            this.checkerIpRanges = CheckerIpRangesCopier.copy(checkerIpRanges);
        }

        @SafeVarargs
        public final void setCheckerIpRanges(String... checkerIpRanges) {
            if (this.checkerIpRanges == null) {
                this.checkerIpRanges = new SdkInternalList<>(checkerIpRanges.length);
            }
            for (String e : checkerIpRanges) {
                this.checkerIpRanges.add(e);
            }
        }

        @Override
        public GetCheckerIpRangesResponse build() {
            return new GetCheckerIpRangesResponse(this);
        }
    }
}
