/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListGeoLocationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListGeoLocationsResponse.Builder, ListGeoLocationsResponse> {
    private final List<GeoLocationDetails> geoLocationDetailsList;

    private final Boolean isTruncated;

    private final String nextContinentCode;

    private final String nextCountryCode;

    private final String nextSubdivisionCode;

    private final String maxItems;

    private ListGeoLocationsResponse(BuilderImpl builder) {
        this.geoLocationDetailsList = builder.geoLocationDetailsList;
        this.isTruncated = builder.isTruncated;
        this.nextContinentCode = builder.nextContinentCode;
        this.nextCountryCode = builder.nextCountryCode;
        this.nextSubdivisionCode = builder.nextSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route 53
     * supports for geolocation.
     * </p>
     * 
     * @return A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon
     *         Route 53 supports for geolocation.
     */
    public List<GeoLocationDetails> geoLocationDetailsList() {
        return geoLocationDetailsList;
    }

    /**
     * <p>
     * A value that indicates whether more locations remain to be listed after the last location in this response. If
     * so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request and
     * include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and
     * <code>NextSubdivisionCode</code> in the <code>StartContinentCode</code>, <code>StartCountryCode</code>, and
     * <code>StartSubdivisionCode</code>, as applicable.
     * </p>
     * 
     * @return A value that indicates whether more locations remain to be listed after the last location in this
     *         response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit
     *         another request and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>,
     *         and <code>NextSubdivisionCode</code> in the <code>StartContinentCode</code>,
     *         <code>StartCountryCode</code>, and <code>StartSubdivisionCode</code>, as applicable.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
     * Enter the value of <code>NextContinentCode</code> in the <code>StartContinentCode</code> parameter in another
     * <code>ListGeoLocations</code> request.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
     *         locations. Enter the value of <code>NextContinentCode</code> in the <code>StartContinentCode</code>
     *         parameter in another <code>ListGeoLocations</code> request.
     */
    public String nextContinentCode() {
        return nextContinentCode;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
     * Enter the value of <code>NextCountryCode</code> in the <code>StartCountryCode</code> parameter in another
     * <code>ListGeoLocations</code> request.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
     *         locations. Enter the value of <code>NextCountryCode</code> in the <code>StartCountryCode</code> parameter
     *         in another <code>ListGeoLocations</code> request.
     */
    public String nextCountryCode() {
        return nextCountryCode;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
     * Enter the value of <code>NextSubdivisionCode</code> in the <code>StartSubdivisionCode</code> parameter in another
     * <code>ListGeoLocations</code> request.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
     *         locations. Enter the value of <code>NextSubdivisionCode</code> in the <code>StartSubdivisionCode</code>
     *         parameter in another <code>ListGeoLocations</code> request.
     */
    public String nextSubdivisionCode() {
        return nextSubdivisionCode;
    }

    /**
     * <p>
     * The value that you specified for <code>MaxItems</code> in the request.
     * </p>
     * 
     * @return The value that you specified for <code>MaxItems</code> in the request.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((geoLocationDetailsList() == null) ? 0 : geoLocationDetailsList().hashCode());
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((nextContinentCode() == null) ? 0 : nextContinentCode().hashCode());
        hashCode = 31 * hashCode + ((nextCountryCode() == null) ? 0 : nextCountryCode().hashCode());
        hashCode = 31 * hashCode + ((nextSubdivisionCode() == null) ? 0 : nextSubdivisionCode().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsResponse)) {
            return false;
        }
        ListGeoLocationsResponse other = (ListGeoLocationsResponse) obj;
        if (other.geoLocationDetailsList() == null ^ this.geoLocationDetailsList() == null) {
            return false;
        }
        if (other.geoLocationDetailsList() != null && !other.geoLocationDetailsList().equals(this.geoLocationDetailsList())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextContinentCode() == null ^ this.nextContinentCode() == null) {
            return false;
        }
        if (other.nextContinentCode() != null && !other.nextContinentCode().equals(this.nextContinentCode())) {
            return false;
        }
        if (other.nextCountryCode() == null ^ this.nextCountryCode() == null) {
            return false;
        }
        if (other.nextCountryCode() != null && !other.nextCountryCode().equals(this.nextCountryCode())) {
            return false;
        }
        if (other.nextSubdivisionCode() == null ^ this.nextSubdivisionCode() == null) {
            return false;
        }
        if (other.nextSubdivisionCode() != null && !other.nextSubdivisionCode().equals(this.nextSubdivisionCode())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (geoLocationDetailsList() != null) {
            sb.append("GeoLocationDetailsList: ").append(geoLocationDetailsList()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (nextContinentCode() != null) {
            sb.append("NextContinentCode: ").append(nextContinentCode()).append(",");
        }
        if (nextCountryCode() != null) {
            sb.append("NextCountryCode: ").append(nextCountryCode()).append(",");
        }
        if (nextSubdivisionCode() != null) {
            sb.append("NextSubdivisionCode: ").append(nextSubdivisionCode()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListGeoLocationsResponse> {
        /**
         * <p>
         * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route
         * 53 supports for geolocation.
         * </p>
         * 
         * @param geoLocationDetailsList
         *        A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon
         *        Route 53 supports for geolocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList);

        /**
         * <p>
         * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route
         * 53 supports for geolocation.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setGeoLocationDetailsList(java.util.Collection)} or
         * {@link #withGeoLocationDetailsList(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param geoLocationDetailsList
         *        A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon
         *        Route 53 supports for geolocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoLocationDetailsList(GeoLocationDetails... geoLocationDetailsList);

        /**
         * <p>
         * A value that indicates whether more locations remain to be listed after the last location in this response.
         * If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request
         * and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and
         * <code>NextSubdivisionCode</code> in the <code>StartContinentCode</code>, <code>StartCountryCode</code>, and
         * <code>StartSubdivisionCode</code>, as applicable.
         * </p>
         * 
         * @param isTruncated
         *        A value that indicates whether more locations remain to be listed after the last location in this
         *        response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values,
         *        submit another request and include the values of <code>NextContinentCode</code>,
         *        <code>NextCountryCode</code>, and <code>NextSubdivisionCode</code> in the
         *        <code>StartContinentCode</code>, <code>StartCountryCode</code>, and <code>StartSubdivisionCode</code>,
         *        as applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
         * Enter the value of <code>NextContinentCode</code> in the <code>StartContinentCode</code> parameter in another
         * <code>ListGeoLocations</code> request.
         * </p>
         * 
         * @param nextContinentCode
         *        If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
         *        locations. Enter the value of <code>NextContinentCode</code> in the <code>StartContinentCode</code>
         *        parameter in another <code>ListGeoLocations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextContinentCode(String nextContinentCode);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
         * Enter the value of <code>NextCountryCode</code> in the <code>StartCountryCode</code> parameter in another
         * <code>ListGeoLocations</code> request.
         * </p>
         * 
         * @param nextCountryCode
         *        If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
         *        locations. Enter the value of <code>NextCountryCode</code> in the <code>StartCountryCode</code>
         *        parameter in another <code>ListGeoLocations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextCountryCode(String nextCountryCode);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
         * Enter the value of <code>NextSubdivisionCode</code> in the <code>StartSubdivisionCode</code> parameter in
         * another <code>ListGeoLocations</code> request.
         * </p>
         * 
         * @param nextSubdivisionCode
         *        If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
         *        locations. Enter the value of <code>NextSubdivisionCode</code> in the
         *        <code>StartSubdivisionCode</code> parameter in another <code>ListGeoLocations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSubdivisionCode(String nextSubdivisionCode);

        /**
         * <p>
         * The value that you specified for <code>MaxItems</code> in the request.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for <code>MaxItems</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private List<GeoLocationDetails> geoLocationDetailsList = new SdkInternalList<>();

        private Boolean isTruncated;

        private String nextContinentCode;

        private String nextCountryCode;

        private String nextSubdivisionCode;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsResponse model) {
            setGeoLocationDetailsList(model.geoLocationDetailsList);
            setIsTruncated(model.isTruncated);
            setNextContinentCode(model.nextContinentCode);
            setNextCountryCode(model.nextCountryCode);
            setNextSubdivisionCode(model.nextSubdivisionCode);
            setMaxItems(model.maxItems);
        }

        public final Collection<GeoLocationDetails> getGeoLocationDetailsList() {
            return geoLocationDetailsList;
        }

        @Override
        public final Builder geoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copy(geoLocationDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocationDetailsList(GeoLocationDetails... geoLocationDetailsList) {
            if (this.geoLocationDetailsList == null) {
                this.geoLocationDetailsList = new SdkInternalList<>(geoLocationDetailsList.length);
            }
            for (GeoLocationDetails e : geoLocationDetailsList) {
                this.geoLocationDetailsList.add(e);
            }
            return this;
        }

        public final void setGeoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copy(geoLocationDetailsList);
        }

        @SafeVarargs
        public final void setGeoLocationDetailsList(GeoLocationDetails... geoLocationDetailsList) {
            if (this.geoLocationDetailsList == null) {
                this.geoLocationDetailsList = new SdkInternalList<>(geoLocationDetailsList.length);
            }
            for (GeoLocationDetails e : geoLocationDetailsList) {
                this.geoLocationDetailsList.add(e);
            }
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextContinentCode() {
            return nextContinentCode;
        }

        @Override
        public final Builder nextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
            return this;
        }

        public final void setNextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
        }

        public final String getNextCountryCode() {
            return nextCountryCode;
        }

        @Override
        public final Builder nextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
            return this;
        }

        public final void setNextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
        }

        public final String getNextSubdivisionCode() {
            return nextSubdivisionCode;
        }

        @Override
        public final Builder nextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
            return this;
        }

        public final void setNextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListGeoLocationsResponse build() {
            return new ListGeoLocationsResponse(this);
        }
    }
}
