/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing information about a request for a list of the tags that are associated with an individual
 * resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTagsForResourceRequest.Builder, ListTagsForResourceRequest> {
    private final String resourceType;

    private final String resourceId;

    private ListTagsForResourceRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource type for health checks is <code>healthcheck</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type for hosted zones is <code>hostedzone</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of the resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The resource type for health checks is <code>healthcheck</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type for hosted zones is <code>hostedzone</code>.
     *         </p>
     *         </li>
     * @see TagResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource for which you want to retrieve tags.
     * </p>
     * 
     * @return The ID of the resource for which you want to retrieve tags.
     */
    public String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceRequest)) {
            return false;
        }
        ListTagsForResourceRequest other = (ListTagsForResourceRequest) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsForResourceRequest> {
        /**
         * <p>
         * The type of the resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(TagResourceType resourceType);

        /**
         * <p>
         * The ID of the resource for which you want to retrieve tags.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource for which you want to retrieve tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceRequest model) {
            setResourceType(model.resourceType);
            setResourceId(model.resourceId);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public ListTagsForResourceRequest build() {
            return new ListTagsForResourceRequest(this);
        }
    }
}
