/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListVPCAssociationAuthorizationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListVPCAssociationAuthorizationsResponse.Builder, ListVPCAssociationAuthorizationsResponse> {
    private final String hostedZoneId;

    private final String nextToken;

    private final List<VPC> vpCs;

    private ListVPCAssociationAuthorizationsResponse(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.nextToken = builder.nextToken;
        this.vpCs = builder.vpCs;
    }

    /**
     * <p>
     * The ID of the hosted zone that you can associate the listed VPCs with.
     * </p>
     * 
     * @return The ID of the hosted zone that you can associate the listed VPCs with.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the
     * specified hosted zone. To get the next page of VPCs, submit another <code>ListVPCAssociationAuthorizations</code>
     * request, and include the value of the <code>NextToken</code> element from the response in the
     * <code>nexttoken</code> request parameter.
     * </p>
     * 
     * @return When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated
     *         with the specified hosted zone. To get the next page of VPCs, submit another
     *         <code>ListVPCAssociationAuthorizations</code> request, and include the value of the
     *         <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The list of VPCs that are authorized to be associated with the specified hosted zone.
     * </p>
     * 
     * @return The list of VPCs that are authorized to be associated with the specified hosted zone.
     */
    public List<VPC> vpCs() {
        return vpCs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZoneId() == null) ? 0 : hostedZoneId().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((vpCs() == null) ? 0 : vpCs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVPCAssociationAuthorizationsResponse)) {
            return false;
        }
        ListVPCAssociationAuthorizationsResponse other = (ListVPCAssociationAuthorizationsResponse) obj;
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.vpCs() == null ^ this.vpCs() == null) {
            return false;
        }
        if (other.vpCs() != null && !other.vpCs().equals(this.vpCs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (vpCs() != null) {
            sb.append("VPCs: ").append(vpCs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListVPCAssociationAuthorizationsResponse> {
        /**
         * <p>
         * The ID of the hosted zone that you can associate the listed VPCs with.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you can associate the listed VPCs with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with
         * the specified hosted zone. To get the next page of VPCs, submit another
         * <code>ListVPCAssociationAuthorizations</code> request, and include the value of the <code>NextToken</code>
         * element from the response in the <code>nexttoken</code> request parameter.
         * </p>
         * 
         * @param nextToken
         *        When the response includes a <code>NextToken</code> element, there are more VPCs that can be
         *        associated with the specified hosted zone. To get the next page of VPCs, submit another
         *        <code>ListVPCAssociationAuthorizations</code> request, and include the value of the
         *        <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of VPCs that are authorized to be associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        The list of VPCs that are authorized to be associated with the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(Collection<VPC> vpCs);

        /**
         * <p>
         * The list of VPCs that are authorized to be associated with the specified hosted zone.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setVPCs(java.util.Collection)} or {@link #withVPCs(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param vpCs
         *        The list of VPCs that are authorized to be associated with the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(VPC... vpCs);
    }

    private static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private String nextToken;

        private List<VPC> vpCs = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVPCAssociationAuthorizationsResponse model) {
            setHostedZoneId(model.hostedZoneId);
            setNextToken(model.nextToken);
            setVPCs(model.vpCs);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VPC> getVPCs() {
            return vpCs;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC... vpCs) {
            if (this.vpCs == null) {
                this.vpCs = new SdkInternalList<>(vpCs.length);
            }
            for (VPC e : vpCs) {
                this.vpCs.add(e);
            }
            return this;
        }

        public final void setVPCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
        }

        @SafeVarargs
        public final void setVPCs(VPC... vpCs) {
            if (this.vpCs == null) {
                this.vpCs = new SdkInternalList<>(vpCs.length);
            }
            for (VPC e : vpCs) {
                this.vpCs.add(e);
            }
        }

        @Override
        public ListVPCAssociationAuthorizationsResponse build() {
            return new ListVPCAssociationAuthorizationsResponse(this);
        }
    }
}
