/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains settings for the new traffic policy instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrafficPolicyInstance implements ToCopyableBuilder<TrafficPolicyInstance.Builder, TrafficPolicyInstance> {
    private final String id;

    private final String hostedZoneId;

    private final String name;

    private final Long ttl;

    private final String state;

    private final String message;

    private final String trafficPolicyId;

    private final Integer trafficPolicyVersion;

    private final String trafficPolicyType;

    private TrafficPolicyInstance(BuilderImpl builder) {
        this.id = builder.id;
        this.hostedZoneId = builder.hostedZoneId;
        this.name = builder.name;
        this.ttl = builder.ttl;
        this.state = builder.state;
        this.message = builder.message;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
        this.trafficPolicyType = builder.trafficPolicyType;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the new traffic policy instance.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the new traffic policy instance.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the hosted zone that Amazon Route 53 created resource record sets in.
     * </p>
     * 
     * @return The ID of the hosted zone that Amazon Route 53 created resource record sets in.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the resource record
     * sets that are associated with this traffic policy instance.
     * </p>
     * 
     * @return The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the
     *         resource record sets that are associated with this traffic policy instance.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the specified hosted
     * zone.
     * </p>
     * 
     * @return The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the specified
     *         hosted zone.
     */
    public Long ttl() {
        return ttl;
    }

    /**
     * <p>
     * The value of <code>State</code> is one of the following values:
     * </p>
     * <dl>
     * <dt>Applied</dt>
     * <dd>
     * <p>
     * Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Amazon Route 53
     * edge locations.
     * </p>
     * </dd>
     * <dt>Creating</dt>
     * <dd>
     * <p>
     * Amazon Route 53 is creating the resource record sets. Use <code>GetTrafficPolicyInstance</code> to confirm that
     * the <code>CreateTrafficPolicyInstance</code> request completed successfully.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * Amazon Route 53 wasn't able to create or update the resource record sets. When the value of <code>State</code> is
     * <code>Failed</code>, see <code>Message</code> for an explanation of what caused the request to fail.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The value of <code>State</code> is one of the following values:</p>
     *         <dl>
     *         <dt>Applied</dt>
     *         <dd>
     *         <p>
     *         Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Amazon
     *         Route 53 edge locations.
     *         </p>
     *         </dd>
     *         <dt>Creating</dt>
     *         <dd>
     *         <p>
     *         Amazon Route 53 is creating the resource record sets. Use <code>GetTrafficPolicyInstance</code> to
     *         confirm that the <code>CreateTrafficPolicyInstance</code> request completed successfully.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         Amazon Route 53 wasn't able to create or update the resource record sets. When the value of
     *         <code>State</code> is <code>Failed</code>, see <code>Message</code> for an explanation of what caused the
     *         request to fail.
     *         </p>
     *         </dd>
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * If <code>State</code> is <code>Failed</code>, an explanation of the reason for the failure. If <code>State</code>
     * is another value, <code>Message</code> is empty.
     * </p>
     * 
     * @return If <code>State</code> is <code>Failed</code>, an explanation of the reason for the failure. If
     *         <code>State</code> is another value, <code>Message</code> is empty.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted
     * zone.
     * </p>
     * 
     * @return The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified
     *         hosted zone.
     */
    public String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The version of the traffic policy that Amazon Route 53 used to create resource record sets in the specified
     * hosted zone.
     * </p>
     * 
     * @return The version of the traffic policy that Amazon Route 53 used to create resource record sets in the
     *         specified hosted zone.
     */
    public Integer trafficPolicyVersion() {
        return trafficPolicyVersion;
    }

    /**
     * <p>
     * The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this traffic
     * policy instance.
     * </p>
     * 
     * @return The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
     *         traffic policy instance.
     * @see RRType
     */
    public String trafficPolicyType() {
        return trafficPolicyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((hostedZoneId() == null) ? 0 : hostedZoneId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((ttl() == null) ? 0 : ttl().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyId() == null) ? 0 : trafficPolicyId().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyVersion() == null) ? 0 : trafficPolicyVersion().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyType() == null) ? 0 : trafficPolicyType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicyInstance)) {
            return false;
        }
        TrafficPolicyInstance other = (TrafficPolicyInstance) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.ttl() == null ^ this.ttl() == null) {
            return false;
        }
        if (other.ttl() != null && !other.ttl().equals(this.ttl())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.trafficPolicyId() == null ^ this.trafficPolicyId() == null) {
            return false;
        }
        if (other.trafficPolicyId() != null && !other.trafficPolicyId().equals(this.trafficPolicyId())) {
            return false;
        }
        if (other.trafficPolicyVersion() == null ^ this.trafficPolicyVersion() == null) {
            return false;
        }
        if (other.trafficPolicyVersion() != null && !other.trafficPolicyVersion().equals(this.trafficPolicyVersion())) {
            return false;
        }
        if (other.trafficPolicyType() == null ^ this.trafficPolicyType() == null) {
            return false;
        }
        if (other.trafficPolicyType() != null && !other.trafficPolicyType().equals(this.trafficPolicyType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (ttl() != null) {
            sb.append("TTL: ").append(ttl()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (trafficPolicyId() != null) {
            sb.append("TrafficPolicyId: ").append(trafficPolicyId()).append(",");
        }
        if (trafficPolicyVersion() != null) {
            sb.append("TrafficPolicyVersion: ").append(trafficPolicyVersion()).append(",");
        }
        if (trafficPolicyType() != null) {
            sb.append("TrafficPolicyType: ").append(trafficPolicyType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TrafficPolicyInstance> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the new traffic policy instance.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigned to the new traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the hosted zone that Amazon Route 53 created resource record sets in.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that Amazon Route 53 created resource record sets in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the resource
         * record sets that are associated with this traffic policy instance.
         * </p>
         * 
         * @param name
         *        The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the
         *        resource record sets that are associated with this traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the specified
         * hosted zone.
         * </p>
         * 
         * @param ttl
         *        The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the
         *        specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * The value of <code>State</code> is one of the following values:
         * </p>
         * <dl>
         * <dt>Applied</dt>
         * <dd>
         * <p>
         * Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Amazon Route
         * 53 edge locations.
         * </p>
         * </dd>
         * <dt>Creating</dt>
         * <dd>
         * <p>
         * Amazon Route 53 is creating the resource record sets. Use <code>GetTrafficPolicyInstance</code> to confirm
         * that the <code>CreateTrafficPolicyInstance</code> request completed successfully.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * Amazon Route 53 wasn't able to create or update the resource record sets. When the value of
         * <code>State</code> is <code>Failed</code>, see <code>Message</code> for an explanation of what caused the
         * request to fail.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param state
         *        The value of <code>State</code> is one of the following values:</p>
         *        <dl>
         *        <dt>Applied</dt>
         *        <dd>
         *        <p>
         *        Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Amazon
         *        Route 53 edge locations.
         *        </p>
         *        </dd>
         *        <dt>Creating</dt>
         *        <dd>
         *        <p>
         *        Amazon Route 53 is creating the resource record sets. Use <code>GetTrafficPolicyInstance</code> to
         *        confirm that the <code>CreateTrafficPolicyInstance</code> request completed successfully.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        Amazon Route 53 wasn't able to create or update the resource record sets. When the value of
         *        <code>State</code> is <code>Failed</code>, see <code>Message</code> for an explanation of what caused
         *        the request to fail.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * If <code>State</code> is <code>Failed</code>, an explanation of the reason for the failure. If
         * <code>State</code> is another value, <code>Message</code> is empty.
         * </p>
         * 
         * @param message
         *        If <code>State</code> is <code>Failed</code>, an explanation of the reason for the failure. If
         *        <code>State</code> is another value, <code>Message</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted
         * zone.
         * </p>
         * 
         * @param trafficPolicyId
         *        The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified
         *        hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The version of the traffic policy that Amazon Route 53 used to create resource record sets in the specified
         * hosted zone.
         * </p>
         * 
         * @param trafficPolicyVersion
         *        The version of the traffic policy that Amazon Route 53 used to create resource record sets in the
         *        specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersion(Integer trafficPolicyVersion);

        /**
         * <p>
         * The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
         * traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyType
         *        The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
         *        traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyType(String trafficPolicyType);

        /**
         * <p>
         * The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
         * traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyType
         *        The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
         *        traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyType(RRType trafficPolicyType);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String hostedZoneId;

        private String name;

        private Long ttl;

        private String state;

        private String message;

        private String trafficPolicyId;

        private Integer trafficPolicyVersion;

        private String trafficPolicyType;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicyInstance model) {
            setId(model.id);
            setHostedZoneId(model.hostedZoneId);
            setName(model.name);
            setTTL(model.ttl);
            setState(model.state);
            setMessage(model.message);
            setTrafficPolicyId(model.trafficPolicyId);
            setTrafficPolicyVersion(model.trafficPolicyVersion);
            setTrafficPolicyType(model.trafficPolicyType);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Long getTTL() {
            return ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        public final String getTrafficPolicyType() {
            return trafficPolicyType;
        }

        @Override
        public final Builder trafficPolicyType(String trafficPolicyType) {
            this.trafficPolicyType = trafficPolicyType;
            return this;
        }

        @Override
        public final Builder trafficPolicyType(RRType trafficPolicyType) {
            this.trafficPolicyType(trafficPolicyType.toString());
            return this;
        }

        public final void setTrafficPolicyType(String trafficPolicyType) {
            this.trafficPolicyType = trafficPolicyType;
        }

        public final void setTrafficPolicyType(RRType trafficPolicyType) {
            this.trafficPolicyType(trafficPolicyType.toString());
        }

        @Override
        public TrafficPolicyInstance build() {
            return new TrafficPolicyInstance(this);
        }
    }
}
