/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * HealthCheckConfig StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class HealthCheckConfigUnmarshaller implements Unmarshaller<HealthCheckConfig, StaxUnmarshallerContext> {

    public HealthCheckConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        HealthCheckConfig.Builder healthCheckConfig = HealthCheckConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("IPAddress", targetDepth)) {
                    healthCheckConfig.ipAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Port", targetDepth)) {
                    healthCheckConfig.port(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Type", targetDepth)) {
                    healthCheckConfig.type(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ResourcePath", targetDepth)) {
                    healthCheckConfig.resourcePath(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FullyQualifiedDomainName", targetDepth)) {
                    healthCheckConfig.fullyQualifiedDomainName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SearchString", targetDepth)) {
                    healthCheckConfig.searchString(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RequestInterval", targetDepth)) {
                    healthCheckConfig.requestInterval(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FailureThreshold", targetDepth)) {
                    healthCheckConfig.failureThreshold(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MeasureLatency", targetDepth)) {
                    healthCheckConfig.measureLatency(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Inverted", targetDepth)) {
                    healthCheckConfig.inverted(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HealthThreshold", targetDepth)) {
                    healthCheckConfig.healthThreshold(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ChildHealthChecks", targetDepth)) {
                    healthCheckConfig.childHealthChecks(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("ChildHealthChecks/ChildHealthCheck", targetDepth)) {
                    healthCheckConfig.childHealthChecks(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EnableSNI", targetDepth)) {
                    healthCheckConfig.enableSNI(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Regions", targetDepth)) {
                    healthCheckConfig.regions(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("Regions/Region", targetDepth)) {
                    healthCheckConfig.regions(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AlarmIdentifier", targetDepth)) {
                    healthCheckConfig.alarmIdentifier(AlarmIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("InsufficientDataHealthStatus", targetDepth)) {
                    healthCheckConfig.insufficientDataHealthStatus(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return healthCheckConfig.build();
    }

    private static HealthCheckConfigUnmarshaller INSTANCE;

    public static HealthCheckConfigUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new HealthCheckConfigUnmarshaller();
        return INSTANCE;
    }
}