/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringUtils;

/**
 * ListReusableDelegationSetsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListReusableDelegationSetsRequestMarshaller implements
        Marshaller<Request<ListReusableDelegationSetsRequest>, ListReusableDelegationSetsRequest> {

    public Request<ListReusableDelegationSetsRequest> marshall(ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) {

        if (listReusableDelegationSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListReusableDelegationSetsRequest> request = new DefaultRequest<ListReusableDelegationSetsRequest>(
                listReusableDelegationSetsRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/2013-04-01/delegationset";

        request.setResourcePath(uriResourcePath);

        if (listReusableDelegationSetsRequest.marker() != null) {
            request.addParameter("marker", StringUtils.fromString(listReusableDelegationSetsRequest.marker()));
        }

        if (listReusableDelegationSetsRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString(listReusableDelegationSetsRequest.maxItems()));
        }

        return request;
    }

}