/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.route53domains.transform.BillingRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information for one billing record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BillingRecord implements StructuredPojo, ToCopyableBuilder<BillingRecord.Builder, BillingRecord> {
    private final String domainName;

    private final String operation;

    private final String invoiceId;

    private final Date billDate;

    private final Double price;

    private BillingRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.operation = builder.operation;
        this.invoiceId = builder.invoiceId;
        this.billDate = builder.billDate;
        this.price = builder.price;
    }

    /**
     * <p>
     * The name of the domain that the billing record applies to. If the domain name contains characters other than a-z,
     * 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode. For more
     * information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS
     * Domain Name Format</a> in the <i>Amazon Route 53 Developer Guidezzz</i>.
     * </p>
     * 
     * @return The name of the domain that the billing record applies to. If the domain name contains characters other
     *         than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode.
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name
     *         Format</a> in the <i>Amazon Route 53 Developer Guidezzz</i>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The operation that you were charged for.
     * </p>
     * 
     * @return The operation that you were charged for.
     * @see OperationType
     */
    public String operation() {
        return operation;
    }

    /**
     * <p>
     * The ID of the invoice that is associated with the billing record.
     * </p>
     * 
     * @return The ID of the invoice that is associated with the billing record.
     */
    public String invoiceId() {
        return invoiceId;
    }

    /**
     * <p>
     * The date that the operation was billed, in Unix format.
     * </p>
     * 
     * @return The date that the operation was billed, in Unix format.
     */
    public Date billDate() {
        return billDate;
    }

    /**
     * <p>
     * The price that you were charged for the operation, in US dollars.
     * </p>
     * <p>
     * Example value: 12.0
     * </p>
     * 
     * @return The price that you were charged for the operation, in US dollars.</p>
     *         <p>
     *         Example value: 12.0
     */
    public Double price() {
        return price;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((operation() == null) ? 0 : operation().hashCode());
        hashCode = 31 * hashCode + ((invoiceId() == null) ? 0 : invoiceId().hashCode());
        hashCode = 31 * hashCode + ((billDate() == null) ? 0 : billDate().hashCode());
        hashCode = 31 * hashCode + ((price() == null) ? 0 : price().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingRecord)) {
            return false;
        }
        BillingRecord other = (BillingRecord) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.operation() == null ^ this.operation() == null) {
            return false;
        }
        if (other.operation() != null && !other.operation().equals(this.operation())) {
            return false;
        }
        if (other.invoiceId() == null ^ this.invoiceId() == null) {
            return false;
        }
        if (other.invoiceId() != null && !other.invoiceId().equals(this.invoiceId())) {
            return false;
        }
        if (other.billDate() == null ^ this.billDate() == null) {
            return false;
        }
        if (other.billDate() != null && !other.billDate().equals(this.billDate())) {
            return false;
        }
        if (other.price() == null ^ this.price() == null) {
            return false;
        }
        if (other.price() != null && !other.price().equals(this.price())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (operation() != null) {
            sb.append("Operation: ").append(operation()).append(",");
        }
        if (invoiceId() != null) {
            sb.append("InvoiceId: ").append(invoiceId()).append(",");
        }
        if (billDate() != null) {
            sb.append("BillDate: ").append(billDate()).append(",");
        }
        if (price() != null) {
            sb.append("Price: ").append(price()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BillingRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BillingRecord> {
        /**
         * <p>
         * The name of the domain that the billing record applies to. If the domain name contains characters other than
         * a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode. For more
         * information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS
         * Domain Name Format</a> in the <i>Amazon Route 53 Developer Guidezzz</i>.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that the billing record applies to. If the domain name contains characters
         *        other than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in
         *        Punycode. For more information, see <a
         *        href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name
         *        Format</a> in the <i>Amazon Route 53 Developer Guidezzz</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The operation that you were charged for.
         * </p>
         * 
         * @param operation
         *        The operation that you were charged for.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operation(String operation);

        /**
         * <p>
         * The operation that you were charged for.
         * </p>
         * 
         * @param operation
         *        The operation that you were charged for.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operation(OperationType operation);

        /**
         * <p>
         * The ID of the invoice that is associated with the billing record.
         * </p>
         * 
         * @param invoiceId
         *        The ID of the invoice that is associated with the billing record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceId(String invoiceId);

        /**
         * <p>
         * The date that the operation was billed, in Unix format.
         * </p>
         * 
         * @param billDate
         *        The date that the operation was billed, in Unix format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billDate(Date billDate);

        /**
         * <p>
         * The price that you were charged for the operation, in US dollars.
         * </p>
         * <p>
         * Example value: 12.0
         * </p>
         * 
         * @param price
         *        The price that you were charged for the operation, in US dollars.</p>
         *        <p>
         *        Example value: 12.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Double price);
    }

    private static final class BuilderImpl implements Builder {
        private String domainName;

        private String operation;

        private String invoiceId;

        private Date billDate;

        private Double price;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingRecord model) {
            setDomainName(model.domainName);
            setOperation(model.operation);
            setInvoiceId(model.invoiceId);
            setBillDate(model.billDate);
            setPrice(model.price);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOperation() {
            return operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(OperationType operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final void setOperation(OperationType operation) {
            this.operation(operation.toString());
        }

        public final String getInvoiceId() {
            return invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public final Date getBillDate() {
            return billDate;
        }

        @Override
        public final Builder billDate(Date billDate) {
            this.billDate = StandardMemberCopier.copy(billDate);
            return this;
        }

        public final void setBillDate(Date billDate) {
            this.billDate = StandardMemberCopier.copy(billDate);
        }

        public final Double getPrice() {
            return price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        @Override
        public BillingRecord build() {
            return new BillingRecord(this);
        }
    }
}
