/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DeleteTagsForDomainRequest includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteTagsForDomainRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteTagsForDomainRequest.Builder, DeleteTagsForDomainRequest> {
    private final String domainName;

    private final List<String> tagsToDelete;

    private DeleteTagsForDomainRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.tagsToDelete = builder.tagsToDelete;
    }

    /**
     * <p>
     * The domain for which you want to delete one or more tags.
     * </p>
     * 
     * @return The domain for which you want to delete one or more tags.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A list of tag keys to delete.
     * </p>
     * 
     * @return A list of tag keys to delete.
     */
    public List<String> tagsToDelete() {
        return tagsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((tagsToDelete() == null) ? 0 : tagsToDelete().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsForDomainRequest)) {
            return false;
        }
        DeleteTagsForDomainRequest other = (DeleteTagsForDomainRequest) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.tagsToDelete() == null ^ this.tagsToDelete() == null) {
            return false;
        }
        if (other.tagsToDelete() != null && !other.tagsToDelete().equals(this.tagsToDelete())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (tagsToDelete() != null) {
            sb.append("TagsToDelete: ").append(tagsToDelete()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteTagsForDomainRequest> {
        /**
         * <p>
         * The domain for which you want to delete one or more tags.
         * </p>
         * 
         * @param domainName
         *        The domain for which you want to delete one or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A list of tag keys to delete.
         * </p>
         * 
         * @param tagsToDelete
         *        A list of tag keys to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToDelete(Collection<String> tagsToDelete);

        /**
         * <p>
         * A list of tag keys to delete.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTagsToDelete(java.util.Collection)} or {@link #withTagsToDelete(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param tagsToDelete
         *        A list of tag keys to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToDelete(String... tagsToDelete);
    }

    private static final class BuilderImpl implements Builder {
        private String domainName;

        private List<String> tagsToDelete = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsForDomainRequest model) {
            setDomainName(model.domainName);
            setTagsToDelete(model.tagsToDelete);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getTagsToDelete() {
            return tagsToDelete;
        }

        @Override
        public final Builder tagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToDelete(String... tagsToDelete) {
            if (this.tagsToDelete == null) {
                this.tagsToDelete = new SdkInternalList<>(tagsToDelete.length);
            }
            for (String e : tagsToDelete) {
                this.tagsToDelete.add(e);
            }
            return this;
        }

        public final void setTagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
        }

        @SafeVarargs
        public final void setTagsToDelete(String... tagsToDelete) {
            if (this.tagsToDelete == null) {
                this.tagsToDelete = new SdkInternalList<>(tagsToDelete.length);
            }
            for (String e : tagsToDelete) {
                this.tagsToDelete.add(e);
            }
        }

        @Override
        public DeleteTagsForDomainRequest build() {
            return new DeleteTagsForDomainRequest(this);
        }
    }
}
