/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListDomains response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDomainsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDomainsResponse.Builder, ListDomainsResponse> {
    private final List<DomainSummary> domains;

    private final String nextPageMarker;

    private ListDomainsResponse(BuilderImpl builder) {
        this.domains = builder.domains;
        this.nextPageMarker = builder.nextPageMarker;
    }

    /**
     * <p>
     * A summary of domains.
     * </p>
     * 
     * @return A summary of domains.
     */
    public List<DomainSummary> domains() {
        return domains;
    }

    /**
     * <p>
     * If there are more domains than you specified for <code>MaxItems</code> in the request, submit another request and
     * include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     * </p>
     * 
     * @return If there are more domains than you specified for <code>MaxItems</code> in the request, submit another
     *         request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     */
    public String nextPageMarker() {
        return nextPageMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domains() == null) ? 0 : domains().hashCode());
        hashCode = 31 * hashCode + ((nextPageMarker() == null) ? 0 : nextPageMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse) obj;
        if (other.domains() == null ^ this.domains() == null) {
            return false;
        }
        if (other.domains() != null && !other.domains().equals(this.domains())) {
            return false;
        }
        if (other.nextPageMarker() == null ^ this.nextPageMarker() == null) {
            return false;
        }
        if (other.nextPageMarker() != null && !other.nextPageMarker().equals(this.nextPageMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domains() != null) {
            sb.append("Domains: ").append(domains()).append(",");
        }
        if (nextPageMarker() != null) {
            sb.append("NextPageMarker: ").append(nextPageMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDomainsResponse> {
        /**
         * <p>
         * A summary of domains.
         * </p>
         * 
         * @param domains
         *        A summary of domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<DomainSummary> domains);

        /**
         * <p>
         * A summary of domains.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDomains(java.util.Collection)} or {@link #withDomains(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param domains
         *        A summary of domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(DomainSummary... domains);

        /**
         * <p>
         * If there are more domains than you specified for <code>MaxItems</code> in the request, submit another request
         * and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
         * </p>
         * 
         * @param nextPageMarker
         *        If there are more domains than you specified for <code>MaxItems</code> in the request, submit another
         *        request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageMarker(String nextPageMarker);
    }

    private static final class BuilderImpl implements Builder {
        private List<DomainSummary> domains = new SdkInternalList<>();

        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            setDomains(model.domains);
            setNextPageMarker(model.nextPageMarker);
        }

        public final Collection<DomainSummary> getDomains() {
            return domains;
        }

        @Override
        public final Builder domains(Collection<DomainSummary> domains) {
            this.domains = DomainSummaryListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainSummary... domains) {
            if (this.domains == null) {
                this.domains = new SdkInternalList<>(domains.length);
            }
            for (DomainSummary e : domains) {
                this.domains.add(e);
            }
            return this;
        }

        public final void setDomains(Collection<DomainSummary> domains) {
            this.domains = DomainSummaryListCopier.copy(domains);
        }

        @SafeVarargs
        public final void setDomains(DomainSummary... domains) {
            if (this.domains == null) {
                this.domains = new SdkInternalList<>(domains.length);
            }
            for (DomainSummary e : domains) {
                this.domains.add(e);
            }
        }

        public final String getNextPageMarker() {
            return nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        @Override
        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }
    }
}
