/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.route53domains.transform.OperationSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * OperationSummary includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationSummary implements StructuredPojo, ToCopyableBuilder<OperationSummary.Builder, OperationSummary> {
    private final String operationId;

    private final String status;

    private final String type;

    private final Date submittedDate;

    private OperationSummary(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.status = builder.status;
        this.type = builder.type;
        this.submittedDate = builder.submittedDate;
    }

    /**
     * <p>
     * Identifier returned to track the requested action.
     * </p>
     * 
     * @return Identifier returned to track the requested action.
     */
    public String operationId() {
        return operationId;
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Type of the action requested.
     * </p>
     * 
     * @return Type of the action requested.
     * @see OperationType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The date when the request was submitted.
     * </p>
     * 
     * @return The date when the request was submitted.
     */
    public Date submittedDate() {
        return submittedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operationId() == null) ? 0 : operationId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((submittedDate() == null) ? 0 : submittedDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationSummary)) {
            return false;
        }
        OperationSummary other = (OperationSummary) obj;
        if (other.operationId() == null ^ this.operationId() == null) {
            return false;
        }
        if (other.operationId() != null && !other.operationId().equals(this.operationId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.submittedDate() == null ^ this.submittedDate() == null) {
            return false;
        }
        if (other.submittedDate() != null && !other.submittedDate().equals(this.submittedDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (operationId() != null) {
            sb.append("OperationId: ").append(operationId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (submittedDate() != null) {
            sb.append("SubmittedDate: ").append(submittedDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OperationSummary> {
        /**
         * <p>
         * Identifier returned to track the requested action.
         * </p>
         * 
         * @param operationId
         *        Identifier returned to track the requested action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * Type of the action requested.
         * </p>
         * 
         * @param type
         *        Type of the action requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the action requested.
         * </p>
         * 
         * @param type
         *        Type of the action requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The date when the request was submitted.
         * </p>
         * 
         * @param submittedDate
         *        The date when the request was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedDate(Date submittedDate);
    }

    private static final class BuilderImpl implements Builder {
        private String operationId;

        private String status;

        private String type;

        private Date submittedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationSummary model) {
            setOperationId(model.operationId);
            setStatus(model.status);
            setType(model.type);
            setSubmittedDate(model.submittedDate);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(OperationStatus status) {
            this.status(status.toString());
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(OperationType type) {
            this.type(type.toString());
        }

        public final Date getSubmittedDate() {
            return submittedDate;
        }

        @Override
        public final Builder submittedDate(Date submittedDate) {
            this.submittedDate = StandardMemberCopier.copy(submittedDate);
            return this;
        }

        public final void setSubmittedDate(Date submittedDate) {
            this.submittedDate = StandardMemberCopier.copy(submittedDate);
        }

        @Override
        public OperationSummary build() {
            return new OperationSummary(this);
        }
    }
}
