/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateDomainContactPrivacy response includes the following element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDomainContactPrivacyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateDomainContactPrivacyResponse.Builder, UpdateDomainContactPrivacyResponse> {
    private final String operationId;

    private UpdateDomainContactPrivacyResponse(BuilderImpl builder) {
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * Identifier for tracking the progress of the request. To use this ID to query the operation status, use
     * GetOperationDetail.
     * </p>
     * 
     * @return Identifier for tracking the progress of the request. To use this ID to query the operation status, use
     *         GetOperationDetail.
     */
    public String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operationId() == null) ? 0 : operationId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactPrivacyResponse)) {
            return false;
        }
        UpdateDomainContactPrivacyResponse other = (UpdateDomainContactPrivacyResponse) obj;
        if (other.operationId() == null ^ this.operationId() == null) {
            return false;
        }
        if (other.operationId() != null && !other.operationId().equals(this.operationId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (operationId() != null) {
            sb.append("OperationId: ").append(operationId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDomainContactPrivacyResponse> {
        /**
         * <p>
         * Identifier for tracking the progress of the request. To use this ID to query the operation status, use
         * GetOperationDetail.
         * </p>
         * 
         * @param operationId
         *        Identifier for tracking the progress of the request. To use this ID to query the operation status, use
         *        GetOperationDetail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);
    }

    private static final class BuilderImpl implements Builder {
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactPrivacyResponse model) {
            setOperationId(model.operationId);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public UpdateDomainContactPrivacyResponse build() {
            return new UpdateDomainContactPrivacyResponse(this);
        }
    }
}
