/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for each resource record set that you want to change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Change implements ToCopyableBuilder<Change.Builder, Change> {
    private final String action;

    private final ResourceRecordSet resourceRecordSet;

    private Change(BuilderImpl builder) {
        this.action = builder.action;
        this.resourceRecordSet = builder.resourceRecordSet;
    }

    /**
     * <p>
     * The action to perform:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes a existing resource record set.
     * </p>
     * <important>
     * <p>
     * To delete the resource record set that is associated with a traffic policy instance, use
     * <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
     * automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon Route
     * 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it even though
     * it's no longer in use.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a resource
     * record set does exist, Amazon Route 53 updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE</code>: Creates a resource record set that has the specified values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE</code>: Deletes a existing resource record set.
     *         </p>
     *         <important>
     *         <p>
     *         To delete the resource record set that is associated with a traffic policy instance, use
     *         <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
     *         automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>,
     *         Amazon Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be
     *         charged for it even though it's no longer in use.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
     *         resource record set does exist, Amazon Route 53 updates it with the values in the request.
     *         </p>
     *         </li>
     * @see ChangeAction
     */
    public ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * The action to perform:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes a existing resource record set.
     * </p>
     * <important>
     * <p>
     * To delete the resource record set that is associated with a traffic policy instance, use
     * <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
     * automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon Route
     * 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it even though
     * it's no longer in use.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a resource
     * record set does exist, Amazon Route 53 updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE</code>: Creates a resource record set that has the specified values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE</code>: Deletes a existing resource record set.
     *         </p>
     *         <important>
     *         <p>
     *         To delete the resource record set that is associated with a traffic policy instance, use
     *         <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
     *         automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>,
     *         Amazon Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be
     *         charged for it even though it's no longer in use.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
     *         resource record set does exist, Amazon Route 53 updates it with the values in the request.
     *         </p>
     *         </li>
     * @see ChangeAction
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Information about the resource record set to create, delete, or update.
     * </p>
     * 
     * @return Information about the resource record set to create, delete, or update.
     */
    public ResourceRecordSet resourceRecordSet() {
        return resourceRecordSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRecordSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(resourceRecordSet(), other.resourceRecordSet());
    }

    @Override
    public String toString() {
        return ToString.builder("Change").add("Action", actionAsString()).add("ResourceRecordSet", resourceRecordSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.of(clazz.cast(actionAsString()));
        case "ResourceRecordSet":
            return Optional.of(clazz.cast(resourceRecordSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Change> {
        /**
         * <p>
         * The action to perform:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE</code>: Creates a resource record set that has the specified values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE</code>: Deletes a existing resource record set.
         * </p>
         * <important>
         * <p>
         * To delete the resource record set that is associated with a traffic policy instance, use
         * <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
         * automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon
         * Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it
         * even though it's no longer in use.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
         * resource record set does exist, Amazon Route 53 updates it with the values in the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to perform:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE</code>: Creates a resource record set that has the specified values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE</code>: Deletes a existing resource record set.
         *        </p>
         *        <important>
         *        <p>
         *        To delete the resource record set that is associated with a traffic policy instance, use
         *        <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
         *        automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>,
         *        Amazon Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be
         *        charged for it even though it's no longer in use.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
         *        resource record set does exist, Amazon Route 53 updates it with the values in the request.
         *        </p>
         *        </li>
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to perform:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE</code>: Creates a resource record set that has the specified values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE</code>: Deletes a existing resource record set.
         * </p>
         * <important>
         * <p>
         * To delete the resource record set that is associated with a traffic policy instance, use
         * <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
         * automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon
         * Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it
         * even though it's no longer in use.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
         * resource record set does exist, Amazon Route 53 updates it with the values in the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to perform:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE</code>: Creates a resource record set that has the specified values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE</code>: Deletes a existing resource record set.
         *        </p>
         *        <important>
         *        <p>
         *        To delete the resource record set that is associated with a traffic policy instance, use
         *        <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
         *        automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>,
         *        Amazon Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be
         *        charged for it even though it's no longer in use.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
         *        resource record set does exist, Amazon Route 53 updates it with the values in the request.
         *        </p>
         *        </li>
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Information about the resource record set to create, delete, or update.
         * </p>
         * 
         * @param resourceRecordSet
         *        Information about the resource record set to create, delete, or update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSet(ResourceRecordSet resourceRecordSet);

        /**
         * <p>
         * Information about the resource record set to create, delete, or update.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceRecordSet.Builder} avoiding the need to
         * create one manually via {@link ResourceRecordSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceRecordSet.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceRecordSet(ResourceRecordSet)}.
         * 
         * @param resourceRecordSet
         *        a consumer that will call methods on {@link ResourceRecordSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRecordSet(ResourceRecordSet)
         */
        default Builder resourceRecordSet(Consumer<ResourceRecordSet.Builder> resourceRecordSet) {
            return resourceRecordSet(ResourceRecordSet.builder().apply(resourceRecordSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private ResourceRecordSet resourceRecordSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            action(model.action);
            resourceRecordSet(model.resourceRecordSet);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final ResourceRecordSet.Builder getResourceRecordSet() {
            return resourceRecordSet != null ? resourceRecordSet.toBuilder() : null;
        }

        @Override
        public final Builder resourceRecordSet(ResourceRecordSet resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet;
            return this;
        }

        public final void setResourceRecordSet(ResourceRecordSet.BuilderImpl resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet != null ? resourceRecordSet.build() : null;
        }

        @Override
        public Change build() {
            return new Change(this);
        }
    }
}
