/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for a change request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeBatch implements ToCopyableBuilder<ChangeBatch.Builder, ChangeBatch> {
    private final String comment;

    private final List<Change> changes;

    private ChangeBatch(BuilderImpl builder) {
        this.comment = builder.comment;
        this.changes = builder.changes;
    }

    /**
     * <p>
     * <i>Optional:</i> Any comments you want to include about a change batch request.
     * </p>
     * 
     * @return <i>Optional:</i> Any comments you want to include about a change batch request.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * Information about the changes to make to the record sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the changes to make to the record sets.
     */
    public List<Change> changes() {
        return changes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(changes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeBatch)) {
            return false;
        }
        ChangeBatch other = (ChangeBatch) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(changes(), other.changes());
    }

    @Override
    public String toString() {
        return ToString.builder("ChangeBatch").add("Comment", comment()).add("Changes", changes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        case "Changes":
            return Optional.of(clazz.cast(changes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeBatch> {
        /**
         * <p>
         * <i>Optional:</i> Any comments you want to include about a change batch request.
         * </p>
         * 
         * @param comment
         *        <i>Optional:</i> Any comments you want to include about a change batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * Information about the changes to make to the record sets.
         * </p>
         * 
         * @param changes
         *        Information about the changes to make to the record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Collection<Change> changes);

        /**
         * <p>
         * Information about the changes to make to the record sets.
         * </p>
         * 
         * @param changes
         *        Information about the changes to make to the record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Change... changes);

        /**
         * <p>
         * Information about the changes to make to the record sets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Change>.Builder} avoiding the need to
         * create one manually via {@link List<Change>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Change>.Builder#build()} is called immediately and its
         * result is passed to {@link #changes(List<Change>)}.
         * 
         * @param changes
         *        a consumer that will call methods on {@link List<Change>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changes(List<Change>)
         */
        Builder changes(Consumer<Change.Builder>... changes);
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private List<Change> changes;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeBatch model) {
            comment(model.comment);
            changes(model.changes);
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Collection<Change.Builder> getChanges() {
            return changes != null ? changes.stream().map(Change::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change... changes) {
            changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<Change.Builder>... changes) {
            changes(Stream.of(changes).map(c -> Change.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChanges(Collection<Change.BuilderImpl> changes) {
            this.changes = ChangesCopier.copyFromBuilder(changes);
        }

        @Override
        public ChangeBatch build() {
            return new ChangeBatch(this);
        }
    }
}
