/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes change information about changes made to your hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeInfo implements ToCopyableBuilder<ChangeInfo.Builder, ChangeInfo> {
    private final String id;

    private final String status;

    private final Instant submittedAt;

    private final String comment;

    private ChangeInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.submittedAt = builder.submittedAt;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The ID of the request.
     * </p>
     * 
     * @return The ID of the request.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied to
     * all Amazon Route 53 DNS servers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the request. <code>PENDING</code> indicates that this request has not yet been
     *         applied to all Amazon Route 53 DNS servers.
     * @see ChangeStatus
     */
    public ChangeStatus status() {
        return ChangeStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied to
     * all Amazon Route 53 DNS servers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the request. <code>PENDING</code> indicates that this request has not yet been
     *         applied to all Amazon Route 53 DNS servers.
     * @see ChangeStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the change request was submitted in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO
     * 8601 format</a> and Coordinated Universal Time (UTC). For example, the value
     * <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.
     * </p>
     * 
     * @return The date and time that the change request was submitted in <a
     *         href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC).
     *         For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751
     *         UTC.
     */
    public Instant submittedAt() {
        return submittedAt;
    }

    /**
     * <p>
     * A complex type that describes change information about changes made to your hosted zone.
     * </p>
     * <p>
     * This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed information
     * about the change.
     * </p>
     * 
     * @return A complex type that describes change information about changes made to your hosted zone.</p>
     *         <p>
     *         This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
     *         information about the change.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submittedAt());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeInfo)) {
            return false;
        }
        ChangeInfo other = (ChangeInfo) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(submittedAt(), other.submittedAt()) && Objects.equals(comment(), other.comment());
    }

    @Override
    public String toString() {
        return ToString.builder("ChangeInfo").add("Id", id()).add("Status", statusAsString()).add("SubmittedAt", submittedAt())
                .add("Comment", comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Status":
            return Optional.of(clazz.cast(statusAsString()));
        case "SubmittedAt":
            return Optional.of(clazz.cast(submittedAt()));
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeInfo> {
        /**
         * <p>
         * The ID of the request.
         * </p>
         * 
         * @param id
         *        The ID of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied
         * to all Amazon Route 53 DNS servers.
         * </p>
         * 
         * @param status
         *        The current state of the request. <code>PENDING</code> indicates that this request has not yet been
         *        applied to all Amazon Route 53 DNS servers.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied
         * to all Amazon Route 53 DNS servers.
         * </p>
         * 
         * @param status
         *        The current state of the request. <code>PENDING</code> indicates that this request has not yet been
         *        applied to all Amazon Route 53 DNS servers.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(ChangeStatus status);

        /**
         * <p>
         * The date and time that the change request was submitted in <a
         * href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC). For
         * example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.
         * </p>
         * 
         * @param submittedAt
         *        The date and time that the change request was submitted in <a
         *        href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time
         *        (UTC). For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at
         *        17:48:16.751 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedAt(Instant submittedAt);

        /**
         * <p>
         * A complex type that describes change information about changes made to your hosted zone.
         * </p>
         * <p>
         * This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
         * information about the change.
         * </p>
         * 
         * @param comment
         *        A complex type that describes change information about changes made to your hosted zone.</p>
         *        <p>
         *        This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
         *        information about the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private Instant submittedAt;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeInfo model) {
            id(model.id);
            status(model.status);
            submittedAt(model.submittedAt);
            comment(model.comment);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getSubmittedAt() {
            return submittedAt;
        }

        @Override
        public final Builder submittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        public final void setSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public ChangeInfo build() {
            return new ChangeInfo(this);
        }
    }
}
