/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateReusableDelegationSetResponse extends Route53Response implements
        ToCopyableBuilder<CreateReusableDelegationSetResponse.Builder, CreateReusableDelegationSetResponse> {
    private final DelegationSet delegationSet;

    private final String location;

    private CreateReusableDelegationSetResponse(BuilderImpl builder) {
        super(builder);
        this.delegationSet = builder.delegationSet;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains name server information.
     * </p>
     * 
     * @return A complex type that contains name server information.
     */
    public DelegationSet delegationSet() {
        return delegationSet;
    }

    /**
     * <p>
     * The unique URL representing the new reusable delegation set.
     * </p>
     * 
     * @return The unique URL representing the new reusable delegation set.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(delegationSet());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetResponse)) {
            return false;
        }
        CreateReusableDelegationSetResponse other = (CreateReusableDelegationSetResponse) obj;
        return Objects.equals(delegationSet(), other.delegationSet()) && Objects.equals(location(), other.location());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateReusableDelegationSetResponse").add("DelegationSet", delegationSet())
                .add("Location", location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DelegationSet":
            return Optional.of(clazz.cast(delegationSet()));
        case "Location":
            return Optional.of(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, CreateReusableDelegationSetResponse> {
        /**
         * <p>
         * A complex type that contains name server information.
         * </p>
         * 
         * @param delegationSet
         *        A complex type that contains name server information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSet(DelegationSet delegationSet);

        /**
         * <p>
         * A complex type that contains name server information.
         * </p>
         * This is a convenience that creates an instance of the {@link DelegationSet.Builder} avoiding the need to
         * create one manually via {@link DelegationSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link DelegationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #delegationSet(DelegationSet)}.
         * 
         * @param delegationSet
         *        a consumer that will call methods on {@link DelegationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegationSet(DelegationSet)
         */
        default Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return delegationSet(DelegationSet.builder().apply(delegationSet).build());
        }

        /**
         * <p>
         * The unique URL representing the new reusable delegation set.
         * </p>
         * 
         * @param location
         *        The unique URL representing the new reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private DelegationSet delegationSet;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetResponse model) {
            super(model);
            delegationSet(model.delegationSet);
            location(model.location);
        }

        public final DelegationSet.Builder getDelegationSet() {
            return delegationSet != null ? delegationSet.toBuilder() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateReusableDelegationSetResponse build() {
            return new CreateReusableDelegationSetResponse(this);
        }
    }
}
