/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the request to remove authorization to associate a VPC that was
 * created by one AWS account with a hosted zone that was created with a different AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteVPCAssociationAuthorizationRequest extends Route53Request implements
        ToCopyableBuilder<DeleteVPCAssociationAuthorizationRequest.Builder, DeleteVPCAssociationAuthorizationRequest> {
    private final String hostedZoneId;

    private final VPC vpc;

    private DeleteVPCAssociationAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * When removing authorization to associate a VPC that was created by one AWS account with a hosted zone that was
     * created with a different AWS account, the ID of the hosted zone.
     * </p>
     * 
     * @return When removing authorization to associate a VPC that was created by one AWS account with a hosted zone
     *         that was created with a different AWS account, the ID of the hosted zone.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * When removing authorization to associate a VPC that was created by one AWS account with a hosted zone that was
     * created with a different AWS account, a complex type that includes the ID and region of the VPC.
     * </p>
     * 
     * @return When removing authorization to associate a VPC that was created by one AWS account with a hosted zone
     *         that was created with a different AWS account, a complex type that includes the ID and region of the VPC.
     */
    public VPC vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVPCAssociationAuthorizationRequest)) {
            return false;
        }
        DeleteVPCAssociationAuthorizationRequest other = (DeleteVPCAssociationAuthorizationRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(vpc(), other.vpc());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteVPCAssociationAuthorizationRequest").add("HostedZoneId", hostedZoneId()).add("VPC", vpc())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        case "VPC":
            return Optional.of(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, DeleteVPCAssociationAuthorizationRequest> {
        /**
         * <p>
         * When removing authorization to associate a VPC that was created by one AWS account with a hosted zone that
         * was created with a different AWS account, the ID of the hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        When removing authorization to associate a VPC that was created by one AWS account with a hosted zone
         *        that was created with a different AWS account, the ID of the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * When removing authorization to associate a VPC that was created by one AWS account with a hosted zone that
         * was created with a different AWS account, a complex type that includes the ID and region of the VPC.
         * </p>
         * 
         * @param vpc
         *        When removing authorization to associate a VPC that was created by one AWS account with a hosted zone
         *        that was created with a different AWS account, a complex type that includes the ID and region of the
         *        VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);

        /**
         * <p>
         * When removing authorization to associate a VPC that was created by one AWS account with a hosted zone that
         * was created with a different AWS account, a complex type that includes the ID and region of the VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link VPC.Builder} avoiding the need to create one
         * manually via {@link VPC#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPC.Builder#build()} is called immediately and its result is
         * passed to {@link #vpc(VPC)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VPC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VPC)
         */
        default Builder vpc(Consumer<VPC.Builder> vpc) {
            return vpc(VPC.builder().apply(vpc).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneId;

        private VPC vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVPCAssociationAuthorizationRequest model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            vpc(model.vpc);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final VPC.Builder getVPC() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteVPCAssociationAuthorizationRequest build() {
            return new DeleteVPCAssociationAuthorizationRequest(this);
        }
    }
}
