/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contain the response to a <code>GetHostedZone</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHostedZoneResponse extends Route53Response implements
        ToCopyableBuilder<GetHostedZoneResponse.Builder, GetHostedZoneResponse> {
    private final HostedZone hostedZone;

    private final DelegationSet delegationSet;

    private final List<VPC> vpCs;

    private GetHostedZoneResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZone = builder.hostedZone;
        this.delegationSet = builder.delegationSet;
        this.vpCs = builder.vpCs;
    }

    /**
     * <p>
     * A complex type that contains general information about the specified hosted zone.
     * </p>
     * 
     * @return A complex type that contains general information about the specified hosted zone.
     */
    public HostedZone hostedZone() {
        return hostedZone;
    }

    /**
     * <p>
     * A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
     * </p>
     * 
     * @return A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
     */
    public DelegationSet delegationSet() {
        return delegationSet;
    }

    /**
     * <p>
     * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains information about the VPCs that are associated with the specified hosted
     *         zone.
     */
    public List<VPC> vpCs() {
        return vpCs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZone());
        hashCode = 31 * hashCode + Objects.hashCode(delegationSet());
        hashCode = 31 * hashCode + Objects.hashCode(vpCs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneResponse)) {
            return false;
        }
        GetHostedZoneResponse other = (GetHostedZoneResponse) obj;
        return Objects.equals(hostedZone(), other.hostedZone()) && Objects.equals(delegationSet(), other.delegationSet())
                && Objects.equals(vpCs(), other.vpCs());
    }

    @Override
    public String toString() {
        return ToString.builder("GetHostedZoneResponse").add("HostedZone", hostedZone()).add("DelegationSet", delegationSet())
                .add("VPCs", vpCs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZone":
            return Optional.of(clazz.cast(hostedZone()));
        case "DelegationSet":
            return Optional.of(clazz.cast(delegationSet()));
        case "VPCs":
            return Optional.of(clazz.cast(vpCs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, GetHostedZoneResponse> {
        /**
         * <p>
         * A complex type that contains general information about the specified hosted zone.
         * </p>
         * 
         * @param hostedZone
         *        A complex type that contains general information about the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZone(HostedZone hostedZone);

        /**
         * <p>
         * A complex type that contains general information about the specified hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link HostedZone.Builder} avoiding the need to create
         * one manually via {@link HostedZone#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostedZone.Builder#build()} is called immediately and its result
         * is passed to {@link #hostedZone(HostedZone)}.
         * 
         * @param hostedZone
         *        a consumer that will call methods on {@link HostedZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZone(HostedZone)
         */
        default Builder hostedZone(Consumer<HostedZone.Builder> hostedZone) {
            return hostedZone(HostedZone.builder().apply(hostedZone).build());
        }

        /**
         * <p>
         * A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
         * </p>
         * 
         * @param delegationSet
         *        A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSet(DelegationSet delegationSet);

        /**
         * <p>
         * A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link DelegationSet.Builder} avoiding the need to
         * create one manually via {@link DelegationSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link DelegationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #delegationSet(DelegationSet)}.
         * 
         * @param delegationSet
         *        a consumer that will call methods on {@link DelegationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegationSet(DelegationSet)
         */
        default Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return delegationSet(DelegationSet.builder().apply(delegationSet).build());
        }

        /**
         * <p>
         * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        A complex type that contains information about the VPCs that are associated with the specified hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(Collection<VPC> vpCs);

        /**
         * <p>
         * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        A complex type that contains information about the VPCs that are associated with the specified hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(VPC... vpCs);

        /**
         * <p>
         * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VPC>.Builder} avoiding the need to create
         * one manually via {@link List<VPC>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VPC>.Builder#build()} is called immediately and its result
         * is passed to {@link #vpCs(List<VPC>)}.
         * 
         * @param vpCs
         *        a consumer that will call methods on {@link List<VPC>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpCs(List<VPC>)
         */
        Builder vpCs(Consumer<VPC.Builder>... vpCs);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private HostedZone hostedZone;

        private DelegationSet delegationSet;

        private List<VPC> vpCs;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneResponse model) {
            super(model);
            hostedZone(model.hostedZone);
            delegationSet(model.delegationSet);
            vpCs(model.vpCs);
        }

        public final HostedZone.Builder getHostedZone() {
            return hostedZone != null ? hostedZone.toBuilder() : null;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        public final DelegationSet.Builder getDelegationSet() {
            return delegationSet != null ? delegationSet.toBuilder() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        public final Collection<VPC.Builder> getVPCs() {
            return vpCs != null ? vpCs.stream().map(VPC::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC... vpCs) {
            vpCs(Arrays.asList(vpCs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(Consumer<VPC.Builder>... vpCs) {
            vpCs(Stream.of(vpCs).map(c -> VPC.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVPCs(Collection<VPC.BuilderImpl> vpCs) {
            this.vpCs = VPCsCopier.copyFromBuilder(vpCs);
        }

        @Override
        public GetHostedZoneResponse build() {
            return new GetHostedZoneResponse(this);
        }
    }
}
