/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Route 53 doesn't have the permissions required to create log streams and send query logs to log streams.
 * Possible causes include the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * There is no resource policy that specifies the log group ARN in the value for <code>Resource</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * The resource policy that includes the log group ARN in the value for <code>Resource</code> doesn't have the necessary
 * permissions.
 * </p>
 * </li>
 * <li>
 * <p>
 * The resource policy hasn't finished propagating yet.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class InsufficientCloudWatchLogsResourcePolicyException extends Route53Exception
        implements
        ToCopyableBuilder<InsufficientCloudWatchLogsResourcePolicyException.Builder, InsufficientCloudWatchLogsResourcePolicyException> {
    private InsufficientCloudWatchLogsResourcePolicyException(BuilderImpl builder) {
        super(builder.message);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, InsufficientCloudWatchLogsResourcePolicyException> {
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InsufficientCloudWatchLogsResourcePolicyException model) {
            this.message = model.getMessage();
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InsufficientCloudWatchLogsResourcePolicyException build() {
            return new InsufficientCloudWatchLogsResourcePolicyException(this);
        }
    }
}
