/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to retrieve a list of the health checks that are associated with the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListHealthChecksRequest extends Route53Request implements
        ToCopyableBuilder<ListHealthChecksRequest.Builder, ListHealthChecksRequest> {
    private final String marker;

    private final String maxItems;

    private ListHealthChecksRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health
     * checks. To get another group, submit another <code>ListHealthChecks</code> request.
     * </p>
     * <p>
     * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
     * which is the ID of the first health check that Amazon Route 53 will return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * health checks to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p>
     *         <p>
     *         For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
     *         response, which is the ID of the first health check that Amazon Route 53 will return if you submit
     *         another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more health checks to get.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the
     * current request. Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value
     * greater than 100, Amazon Route 53 returns only the first 100 health checks.
     * </p>
     * 
     * @return The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to
     *         the current request. Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to
     *         a value greater than 100, Amazon Route 53 returns only the first 100 health checks.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthChecksRequest)) {
            return false;
        }
        ListHealthChecksRequest other = (ListHealthChecksRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        return ToString.builder("ListHealthChecksRequest").add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, ListHealthChecksRequest> {
        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health
         * checks. To get another group, submit another <code>ListHealthChecks</code> request.
         * </p>
         * <p>
         * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         * response, which is the ID of the first health check that Amazon Route 53 will return if you submit another
         * request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * health checks to get.
         * </p>
         * 
         * @param marker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p>
         *        <p>
         *        For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         *        response, which is the ID of the first health check that Amazon Route 53 will return if you submit
         *        another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more health checks to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the
         * current request. Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value
         * greater than 100, Amazon Route 53 returns only the first 100 health checks.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response
         *        to the current request. Amazon Route 53 returns a maximum of 100 items. If you set
         *        <code>MaxItems</code> to a value greater than 100, Amazon Route 53 returns only the first 100 health
         *        checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHealthChecksRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListHealthChecksRequest build() {
            return new ListHealthChecksRequest(this);
        }
    }
}
